/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.components;

import cn.myapps.common.dao.JDBCUtil;
import com.bcxin.runtime.apis.dtos.ChangeLogContext;
import com.bcxin.runtime.domain.constants.FieldNames;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

public interface MappingSqlValueTranslator {
    public String get(ChangeLogContext var1, String var2, String var3, Object var4);

    @Component
    public static class MappingSqlValueTranslatorImpl
    implements MappingSqlValueTranslator {
        @Override
        public String get(ChangeLogContext logContext, String sqlFormat, String key, Object originalValue) {
            String colPlaceHolder = "\\#\\{" + String.valueOf(key) + "\\}";
            String colPlaceHolder2 = "\\#\\{item_" + String.valueOf(key) + "\\}";
            Object colValue = originalValue;
            try {
                if (colValue == null) {
                    colPlaceHolder = String.format("'%s'", colPlaceHolder);
                    colPlaceHolder2 = String.format("'%s'", colPlaceHolder2);
                    colValue = "NULL";
                } else {
                    String pathFieldExpress = String.format("#{path:%s}", key);
                    if (FieldNames.isFile((String)String.valueOf(key)) || sqlFormat.contains(pathFieldExpress)) {
                        colValue = FieldNames.formattedFileValue((String)"", (String)"manually", (String)"manually", (String)String.valueOf(colValue));
                    }
                }
                if (key.equalsIgnoreCase("ISTMP")) {
                    String isTmpValue = this.getValue(colValue);
                    if (StringUtils.hasLength((String)isTmpValue)) {
                        isTmpValue = isTmpValue.replace("'", "");
                    }
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), isTmpValue);
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), isTmpValue);
                } else {
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), this.getValue(colValue));
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), this.getValue(colValue));
                }
                return sqlFormat;
            }
            catch (Exception ex) {
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), this.getValue(ex.getMessage()));
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), this.getValue(ex.getMessage()));
                return sqlFormat;
            }
        }

        private String getValue(Object value) {
            if (value == null) {
                return String.valueOf(value);
            }
            return JDBCUtil.toSqlStringValue((Object)value);
        }
    }
}

