/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.util.file.RemoteFileCompressor;
import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.controllers.SecurityControllerAbstract;
import com.bcxin.runtime.apis.requests.CompressFileToZipRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/extends/compress"})
public class CompressController
extends SecurityControllerAbstract {
    private final RegionConfig regionConfig;
    private final PropertiesConfig propertiesConfig;

    public CompressController(RegionConfig regionConfig, PropertiesConfig propertiesConfig) {
        this.regionConfig = regionConfig;
        this.propertiesConfig = propertiesConfig;
    }

    @PostMapping(value={"/fileIntoZip"})
    public void getFileIntoZIP(@RequestBody CompressFileToZipRequest compressFileToZipRequest, HttpServletResponse response) {
        try {
            ArrayList<String> allExtractPaths = new ArrayList<String>();
            for (String path : compressFileToZipRequest.getFilePaths()) {
                if (path == null) continue;
                if (!path.startsWith("http")) {
                    path = this.regionConfig.getSourceSite() + String.format("/obpm/%s", path).replace("//", "/");
                }
                allExtractPaths.add(path);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String timestamp = sdf.format(new Date());
            String zipPath = this.propertiesConfig.getStorageroot() + compressFileToZipRequest.getDestDir() + timestamp + "/" + compressFileToZipRequest.getNewFileName() + ".zip";
            RemoteFileCompressor.compressRemoteFiles((String[])allExtractPaths.toArray(new String[0]), (String)zipPath);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(zipPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

