/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.controllers.SecurityControllerAbstract;
import com.bcxin.runtime.apis.requests.ChangeLogMappingRequest;
import com.bcxin.runtime.apis.responses.ChangeLogMappingResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/extends/change-mapping"})
public class ChangeLogMappingController
extends SecurityControllerAbstract {
    private final String INSERT_CHANGE_LOG_MAPPING = "INSERT INTO dynamic_data_map_templates(mapkey,template,note,createdTime)values(?,?,?,CURRENT_TIMESTAMP )";
    private final String UPDATE_CHANGE_LOG_MAPPING = "update dynamic_data_map_templates set mapkey=?,template=?,note=? where id=?";
    private final String GET_CHANGE_LOG_MAPPING = "select * from dynamic_data_map_templates where id=?";
    private final JdbcTemplate jdbcTemplate;
    private final RegionConfig regionConfig;

    public ChangeLogMappingController(JdbcTemplate jdbcTemplate, RegionConfig regionConfig) {
        this.jdbcTemplate = jdbcTemplate;
        this.regionConfig = regionConfig;
    }

    @GetMapping
    @Async
    public CompletableFuture<ResponseEntity> get() {
        List logMappingResponses = this.jdbcTemplate.query("SELECT * FROM dynamic_data_map_templates", (rs, rsNum) -> {
            String mapKey = rs.getString("mapKey");
            String template = rs.getString("template");
            String note = rs.getString("note");
            boolean isOnline = rs.getBoolean("is_online");
            String id = rs.getString("id");
            return ChangeLogMappingResponse.create(id, mapKey, template, note, isOnline);
        });
        return CompletableFuture.completedFuture(ResponseEntity.ok((Object)logMappingResponses));
    }

    @GetMapping(value={"/{id}"})
    public CompletableFuture<ResponseEntity> get(@PathVariable String id) {
        ChangeLogMappingResponse response = (ChangeLogMappingResponse)this.jdbcTemplate.queryForObject("select * from dynamic_data_map_templates where id=?", new Object[]{id}, (rs, rowNum) -> {
            String mapKey = rs.getString("mapKey");
            String template = rs.getString("template");
            String note = rs.getString("note");
            boolean isOnline = rs.getBoolean("is_online");
            String rid = rs.getString("id");
            return ChangeLogMappingResponse.create(rid, mapKey, template, note, isOnline);
        });
        return CompletableFuture.completedFuture(ResponseEntity.ok((Object)response));
    }

    @PostMapping
    @Async
    public CompletableFuture<ResponseEntity> post(@RequestBody ChangeLogMappingRequest request) {
        if (!this.checkIfAllowedAccess()) {
            return CompletableFuture.completedFuture(ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)"\u8be5\u73af\u5883\u65e0\u6cd5\u8bbf\u95ee\u8be5\u670d\u52a1\uff01"));
        }
        Object[] param = new Object[]{request.getMapKey(), request.getTemplate(), request.getNote()};
        this.jdbcTemplate.update("INSERT INTO dynamic_data_map_templates(mapkey,template,note,createdTime)values(?,?,?,CURRENT_TIMESTAMP )", param);
        return this.get();
    }

    @PutMapping(value={"/{id}"})
    @Async
    public CompletableFuture<ResponseEntity> put(@PathVariable String id, @RequestBody ChangeLogMappingRequest request) {
        if (!this.checkIfAllowedAccess()) {
            return CompletableFuture.completedFuture(ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)"\u8be5\u73af\u5883\u65e0\u6cd5\u8bbf\u95ee\u8be5\u670d\u52a1\uff01"));
        }
        Object[] param = new Object[]{request.getMapKey(), request.getTemplate(), request.getNote(), id};
        this.jdbcTemplate.update("update dynamic_data_map_templates set mapkey=?,template=?,note=? where id=?", param);
        return this.get(id);
    }

    private boolean checkIfAllowedAccess() {
        return !this.regionConfig.isDisabled();
    }
}

