/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.components;

import cn.myapps.components.MessageProvider;
import cn.myapps.components.requests.CreateMessageRequest;
import com.bcxin.runtime.domain.messages.commands.BatchCreateMessageCommand;
import com.bcxin.runtime.domain.messages.commands.CreateMessageCommand;
import com.bcxin.runtime.domain.messages.services.MessageService;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class MessageProviderImpl
implements MessageProvider {
    private final MessageService messageService;

    public MessageProviderImpl(MessageService messageService) {
        this.messageService = messageService;
    }

    public void dispatch(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, String businessNumber, String uniqueId) {
        this.messageService.dispatch(CreateMessageCommand.create((String)senderId, (MessageType)messageType, (String)title, (String)content, (ReceiverType)receiverType, (String)receiver, Collections.emptyMap(), (String)businessNumber, (String)uniqueId));
    }

    public void dispatch(CreateMessageRequest request) {
        this.messageService.dispatch(CreateMessageCommand.create((String)request.getSenderId(), (MessageType)request.getMessageType(), (String)request.getTitle(), (String)request.getContent(), (ReceiverType)request.getReceiverType(), (String)request.getReceiver(), Collections.emptyMap(), (String)request.getBusinessNumber(), (String)request.getUniqueId()));
    }

    public void dispatch(Collection<CreateMessageRequest> requests) {
        this.messageService.dispatch(BatchCreateMessageCommand.create((Collection)requests.stream().map(ii -> CreateMessageCommand.create((String)ii.getSenderId(), (MessageType)ii.getMessageType(), (String)ii.getTitle(), (String)ii.getContent(), (ReceiverType)ii.getReceiverType(), (String)ii.getReceiver(), Collections.emptyMap(), (String)ii.getBusinessNumber(), (String)ii.getUniqueId())).collect(Collectors.toList())));
    }
}

