package com.bcxin.rest.sys.mail;


import com.bcxin.common.constants.GlobalConfig;
import com.bcxin.util.toolbox.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.internet.MimeMessage.RecipientType;
import java.io.File;
import java.util.List;
import java.util.Properties;


public class SendEmailAndMsgUtil {


	private volatile static SendEmailAndMsgUtil sendEmailAndMsgUtil;

	/**
	 * 单列模式
	 * @return
	 */
	public static SendEmailAndMsgUtil getSendEmailAndMsgUtil() {
		if (sendEmailAndMsgUtil == null) {
			 synchronized (SendEmailAndMsgUtil.class) {
				 if (sendEmailAndMsgUtil == null) {
					 sendEmailAndMsgUtil = new SendEmailAndMsgUtil();
				 }
			 }
		}
		return sendEmailAndMsgUtil;
	}

	private SendEmailAndMsgUtil(){

	}

	private final static String CHARSET = "utf-8";
	
	private static String host;// 发送方邮箱所在的smtp主机
	private static String from;// 发送方邮箱
	private static String bcc;// 密送方邮箱
	private static String emailPassword;// 密码
	private static String bcxHead;
	private static String bcxFooter;

	private static Session session;
	
	private static String msgAccount = "";// 账户
	private static String msgPassword = "";// 密码
	private static String serviceURL = ""; //短信调用地址
	private static String up_serviceURL = ""; //短信上行调用地址
	private static String gasPolicy_path = ""; //燃气保险电子保单存放地址

	private static String sender_username = "";
	private static Transport transport;

	private static MimeMessage message;

	public String typeName;
	
	final static Logger logger = LoggerFactory.getLogger(SendEmailAndMsgUtil.class);

	static {
		host = GlobalConfig.getConfig("mail_host");
		from =  GlobalConfig.getConfig("mail_from");
		bcc =  GlobalConfig.getConfig("mail_bcc");
		emailPassword =  GlobalConfig.getConfig("mail_password");
		bcxHead =  GlobalConfig.getConfig("mail_bcxHead");
		bcxFooter =  GlobalConfig.getConfig("mail_bcxFooter");
		
		serviceURL =  GlobalConfig.getConfig("msgServiceUrl");
		up_serviceURL =  GlobalConfig.getConfig("msgUpServiceUrl");
		msgAccount =  GlobalConfig.getConfig("msg_account");
		msgPassword =  GlobalConfig.getConfig("msg_pwd");

		Properties props = new Properties();
		props.put("mail.smtp.host", host);// 设置smtp主机
		props.put("mail.smtp.auth", "true");// 使用smtp身份验证
		session = Session.getDefaultInstance(props, null);
		message = new MimeMessage(session);
		sender_username = from;


	}

	public  static void sendPDFEmail(EmailModel emailModel, String proContNo) {
		if (emailModel.getTo() == null || emailModel.getTo().size() < 1)
			return;
		
		try {
			String typeName = "";
			String content = "";
			if(StrUtil.isNotBlank(emailModel.getEmailType())) {
				typeName = "百川信";// 发送方名称
				content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
			}
			Properties props = new Properties();
			// Setup mail server
			props.put("mail.smtp.host", host);// 设置smtp主机
			props.put("mail.smtp.auth", "true");// 使用smtp身份验证
			// Get session
			Session session = Session.getDefaultInstance(props, null);
			// Define message
			MimeMessage message = new MimeMessage(session);
			message.setFrom(new InternetAddress(from, typeName));
			message.setSubject(emailModel.getSubject());
			Multipart multipart = new MimeMultipart();
			BodyPart bodyPart = new MimeBodyPart();
			
			bodyPart.setContent(content, "text/html;charset=UTF-8");
			multipart.addBodyPart(bodyPart);
			
			//加入附件
			if (proContNo != null) {
				
				File file = new File(gasPolicy_path, proContNo+".pdf");

				if(file!=null && file.exists()){
					bodyPart = new MimeBodyPart();
					DataSource datasource = new FileDataSource(file);
					bodyPart.setDataHandler(new DataHandler(datasource)); 
					bodyPart.setFileName(MimeUtility.encodeWord(proContNo + ".pdf","utf-8", null)); 
					multipart.addBodyPart(bodyPart);
				}else{
					String err = "投保单号："+proContNo;
					if(file != null) {
						err += ("路径："+file.getAbsolutePath());
					}
					logger.error("文件不存在，" + err);
				}
				
			}
			
			for(String filePath : emailModel.getFilePath()) {
				FileDataSource fds = new FileDataSource(filePath);
				BodyPart attachBodyPart = new MimeBodyPart();
				attachBodyPart.setDataHandler(new DataHandler(fds));
				
				attachBodyPart.setFileName(MimeUtility.encodeWord(fds.getName()));
				multipart.addBodyPart(attachBodyPart);
			}
			
			for(String recipient : emailModel.getTo()) {
				message.addRecipient(Message.RecipientType.TO, new InternetAddress(recipient));
			}
			message.setRecipient(RecipientType.BCC, new InternetAddress(bcc, typeName));
			
			message.setContent(multipart);
			message.saveChanges();
			Transport transport = session.getTransport("smtp");
			transport.connect(host, from, emailPassword);
			transport.sendMessage(message, message.getAllRecipients());
			
		} catch (Exception e) {
			e.printStackTrace();
		}		
	}
	

	/**
	 * 发送邮件
	 *
	 * @param subject
	 *            邮件主题
	 * @param sendHtml
	 *            邮件内容
	 * @param attachment
	 *            附件
	 */
	public  void doSendHtmlEmail(String subject, String sendHtml, List<String> receiveUsers, File attachment, List<String> ccUserList, List<String> bccUserList) {
		try {
			// 发件人
			InternetAddress from = new InternetAddress(sender_username);
			message.setFrom(from);

			if ( receiveUsers == null || receiveUsers.size() < 1) {
				return;
			}

			// 收件人
			InternetAddress[] receive =new InternetAddress[receiveUsers.size()];
			for(int i=0;i<receiveUsers.size() ; i++){
				receive[i] = new InternetAddress( receiveUsers.get(i));
			}
			message.setRecipients(Message.RecipientType.TO,receive);

			//抄送人
			if(ccUserList !=null && ccUserList.size() > 0){
				InternetAddress[] cc =new InternetAddress[ccUserList.size()];
				for(int i=0;i<ccUserList.size() ; i++){
					cc[i] = new InternetAddress( ccUserList.get(i));
				}
				message.setRecipients(Message.RecipientType.CC,cc);
			}

			//密送人
			if(bccUserList !=null && bccUserList.size() > 0){
				InternetAddress[] bcc =new InternetAddress[bccUserList.size()];
				for(int i=0;i<bccUserList.size() ; i++){
					bcc[i] = new InternetAddress( bccUserList.get(i));
				}
				message.setRecipients(Message.RecipientType.BCC,bcc);
			}
			// 邮件主题
			message.setSubject(subject);

			// 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
			Multipart multipart = new MimeMultipart();

			// 添加邮件正文
			BodyPart contentPart = new MimeBodyPart();
			contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
			multipart.addBodyPart(contentPart);

			// 添加附件的内容
			if (attachment != null) {
				BodyPart attachmentBodyPart = new MimeBodyPart();
				DataSource source = new FileDataSource(attachment);
				attachmentBodyPart.setDataHandler(new DataHandler(source));

				// 网上流传的解决文件名乱码的方法，其实用MimeUtility.encodeWord就可以很方便的搞定
				// 这里很重要，通过下面的Base64编码的转换可以保证你的中文附件标题名在发送时不会变成乱码
				//sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
				//messageBodyPart.setFileName("=?GBK?B?" + enc.encode(attachment.getName().getBytes()) + "?=");

				//MimeUtility.encodeWord可以避免文件名乱码
				attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
				multipart.addBodyPart(attachmentBodyPart);
			}

			// 将multipart对象放到message中
			message.setContent(multipart);
			// 保存邮件
			message.saveChanges();

			transport = session.getTransport("smtp");
			// smtp验证，就是你用来发邮件的邮箱用户名密码
			transport.connect(host, sender_username, emailPassword);
			// 发送
			transport.sendMessage(message, message.getAllRecipients());

			System.out.println("send success!");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (transport != null) {
				try {
					transport.close();
				} catch (MessagingException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 发送邮件
	 *
	 * @param subject
	 *            邮件主题
	 * @param sendHtml
	 *            邮件内容
	 * @param receiveUser
	 *            收件人地址
	 */
	public void sendEmail(String subject, String sendHtml, String receiveUser) {
		try {
			// 发件人
			InternetAddress from = new InternetAddress(sender_username);
			message.setFrom(from);

			if ( StrUtil.isBlank(receiveUser) ) {
				return;
			}
			// 收件人
			InternetAddress to = new InternetAddress(receiveUser);
			message.setRecipient(Message.RecipientType.TO, to);
			// 邮件主题
			message.setSubject(subject);
			// 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
			Multipart multipart = new MimeMultipart();

			// 添加邮件正文
			BodyPart contentPart = new MimeBodyPart();
			contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
			multipart.addBodyPart(contentPart);
			// 将multipart对象放到message中
			message.setContent(multipart);
			// 保存邮件
			message.saveChanges();

			transport = session.getTransport("smtp");
			// smtp验证，就是你用来发邮件的邮箱用户名密码
			transport.connect(host, sender_username, emailPassword);
			// 发送
			transport.sendMessage(message, message.getAllRecipients());

			System.out.println("send success!");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (transport != null) {
				try {
					transport.close();
				} catch (MessagingException e) {
					e.printStackTrace();
				}
			}
		}
	}
	/**
	 * 发送邮件
	 *
	 * @param subject
	 *            邮件主题
	 * @param sendHtml
	 *            邮件内容
	 * @param receiveUser
	 *            收件人地址
	 * @param attachment
	 *            附件
	 */
	public void doSendHtmlEmail(String subject, String sendHtml, String receiveUser, File attachment, List<String> bccUserList) {
		try {
			// 发件人
			InternetAddress from = new InternetAddress(sender_username);
			message.setFrom(from);

			if (StrUtil.isBlank(receiveUser) ) {
				return;
			}
			// 收件人
			InternetAddress to = new InternetAddress(receiveUser);
//            if(bccUserList !=null && bccUserList.size() > 0){
//	            InternetAddress[] cc =new InternetAddress[bccUserList.size()];
//	            for(int i=0;i<bccUserList.size() ; i++){
//	            	cc[i] = new InternetAddress( bccUserList.get(i));
//	            }
//	            message.setRecipients(Message.RecipientType.CC,cc);
//            }
			message.setRecipient(Message.RecipientType.TO, to);

            /*InternetAddress bcc = new InternetAddress("linqinglin@bcxin.com.cn");
            message.setRecipient(Message.RecipientType.BCC, bcc);*/
			// 邮件主题
			message.setSubject(subject);

			// 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
			Multipart multipart = new MimeMultipart();

			// 添加邮件正文
			BodyPart contentPart = new MimeBodyPart();
			contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
			multipart.addBodyPart(contentPart);

			// 添加附件的内容
			if (attachment != null) {
				BodyPart attachmentBodyPart = new MimeBodyPart();
				DataSource source = new FileDataSource(attachment);
				attachmentBodyPart.setDataHandler(new DataHandler(source));

				// 网上流传的解决文件名乱码的方法，其实用MimeUtility.encodeWord就可以很方便的搞定
				// 这里很重要，通过下面的Base64编码的转换可以保证你的中文附件标题名在发送时不会变成乱码
				//sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
				//messageBodyPart.setFileName("=?GBK?B?" + enc.encode(attachment.getName().getBytes()) + "?=");

				//MimeUtility.encodeWord可以避免文件名乱码
				attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
				multipart.addBodyPart(attachmentBodyPart);
			}

			// 将multipart对象放到message中
			message.setContent(multipart);
			// 保存邮件
			message.saveChanges();

			transport = session.getTransport("smtp");
			// smtp验证，就是你用来发邮件的邮箱用户名密码
			transport.connect(host, sender_username, emailPassword);
			// 发送
			transport.sendMessage(message, message.getAllRecipients());

			System.out.println("send success!");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (transport != null) {
				try {
					transport.close();
				} catch (MessagingException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}
}
