package com.bcxin.rest.sys.mail;

public class MessageModel {
	private String msgType;
	private String to ;
	private String content;

	public MessageModel(){}
	
	public MessageModel(EmailMsgType type,String productName,String policyNum,String date) {
		switch (type) {
		case INSURE_POLICY:
			this.content = "尊敬的客户，您好！您投保的"+productName+"已经承保成功，保单号："+policyNum+"，保单生效日期："+date+"。"
					+ "如有疑问，请致电4009979696咨询。";
			break;
		case INSURE_POLICY_FAILD:
			this.content = "尊敬的客户，您好！您投保的"+productName+"承保失败，请及时致电4009979696进行咨询。";
			break;
		case APPLYFOR:
			this.content = "您好！有新订单生成！请及时登录保险保函网（http://www.bailianbao.cn）进行查看。";
			break;
		case PASSUNDERWRITING:
			this.content = "您好！保险公司已核保通过，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。";
			break;
		case ACCOUNTPAID:
			this.content = "您好！用户已缴费，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。";
			break;
		case UPLOADBACKLETTER:
			this.content = "您好！保险公司已上传保单、保函，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。";
			break;
		default:
			break;
		}
	}
	
	public MessageModel(String code, EmailMsgType type) {
		switch (type) {
		case AUTHCODE:
			this.content = "尊敬的客户，您的校验码："+code+"，工作人员不会索取，请勿泄露。"
					+ "如有疑问，请致电4009979696咨询。";
			break;
		default:
			break;
		}
	}
	
	public String getTo() {
		return to;
	}

	public void setTo(String to) {
		this.to = to;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public void addTo(String email) {
		setTo(email);
	}

	public String getMsgType() {
		return msgType;
	}

	public void setMsgType(String msgType) {
		this.msgType = msgType;
	}
	
}
