package com.bcxin.rest.sys.login.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.security.UsernamePassword;
import com.bcxin.core.service.SysUserService;
import com.bcxin.core.util.SysUserUtils;
import com.bcxin.spring.cache.CacheUtils;
import com.bcxin.spring.security.Principal;
import com.bcxin.spring.util.ServletUtils;
import com.bcxin.util.Encodes;
import com.bcxin.util.MD5Utils;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 *
 * 用户登录接口
 * Created by playboy on 2017/5/22.
 */
@Controller
@RequestMapping(value = "${apiPath}/")
public class SysLoginApiController extends BaseController {

    @Autowired
    private SysUserService sysUserService;
    /**
     * 单点登录（如已经登录，则直接跳转）
     * @param loginName 登录用户编码
     * @param bcxinToken 登录令牌，令牌组成：sso密钥+用户名+日期，进行md5加密，举例：
     *      String secretKey = Global.getConfig("shiro.sso.secretKey");
     *      String token = MD5Utils.md5(secretKey + userCode + DateUtils.getTimestamp());
     * @param redirectToUrl 登录成功后跳转的url地址。
     * @param relogin 是否重新登录，需要重新登录传递true
     */
    @RequestMapping("sso")
    public String sso(HttpServletResponse response,String loginName, String bcxinToken, @RequestParam(required=true)String password , String redirectToUrl, String relogin, Model model) {
        Principal principal = SysUserUtils.getPrincipal();
        String  email = this.getParameter("email");
        String phone = this.getParameter("telephone");
        String sign = this.getParameter("sign");

        if(StrUtil.isBlank(loginName)&&StrUtil.isBlank(email)&&StrUtil.isBlank(phone)){
            return this.renderString(response, new AjaxResult(false, "登录账号不能为空"));
        }
        if(StrUtil.isBlank(sign)){
            return this.renderString(response, new AjaxResult(false, "平台标识不能为空"));
        }
        if(principal != null) {
            if(BooleanUtils.toBoolean(relogin)){
                SysUserUtils.getSubject().logout();
            }else{
                return this.redirectTo(Encodes.urlDecode(redirectToUrl));
            }
        }
        if(StrUtil.isBlank(bcxinToken)) {
            String name = loginName;
            if(StrUtil.isBlank(loginName)){
                name = email;
            }
            if(StrUtil.isBlank(loginName)){
                name = phone;
            }
            bcxinToken = MD5Utils.string2MD5(name + DateUtil.getTimestamp() + GlobalConstants.getConfig("shiro.sso.secretKey"));
        }
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePassword token = new UsernamePassword(loginName, password, bcxinToken);
        token.setEmail(email);
        token.setPhone(phone);
        token.setSign(sign);
        token.setRememberMe(true);
        try {
            currentUser.login(token);
        } catch (UnknownAccountException e) {
            return this.renderString(response, new AjaxResult(false, "该账号不存在"));
        } catch (DisabledAccountException e) {
            return this.renderString(response, new AjaxResult(false, "该账号已被冻结"));
        } catch (IncorrectCredentialsException e) {
            return this.renderString(response, new AjaxResult(false, "账号或密码错误"));
        } catch (AuthenticationException e) {
            return this.renderString(response, new AjaxResult(false, "该已帐号禁止登录"));
        } catch (RuntimeException e) {
            return this.renderString(response, new AjaxResult(false, "未知错误"));
        }
        CacheUtils.put(bcxinToken,SysUserUtils.getSession().getId());
        Map<String,Object> map = Maps.newHashMap();
        map.put("token",bcxinToken);
        map.put("user",SysUserUtils.getUser());
        //添加登录日志
        sysUserService.updateLogByLoginName(SysUserUtils.getPrincipal().getId(), ServletUtils.getIpAddr(), ServletUtils.getUserBrowser(), ServletUtils.getUserOperatingSystem());
        return this.renderString(response,new AjaxResult(true,"登录成功",map));
    }

    /**
     * 登出
     * @return
     */
    @RequestMapping(value = "/logout",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult loginOut() {
        JSONObject  json =new JSONObject();
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        CacheUtils.remove(this.getParameter("bcxinToken"));
        return  success(true, "操作成功!!");
    }
}
