package com.bcxin.rest.product.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.product.entity.ProductType;
import com.bcxin.models.product.service.ProductTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * 查询产品分类接口
 * Created by playboy on 2017/5/27.
 */
@Controller
@RequestMapping("${apiPath}/webProductType")
public class ProductTypeApiController extends BaseController {

    @Autowired
    private ProductTypeService productTypeService;

    @RequestMapping(value = "/findList",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult listData(Model model, @RequestParam(required = true) String type,String startDate){
        ProductType productType = new ProductType();
        productType.setType(type);
        productType.setStartDate(startDate);
        return new AjaxResult(true,"操作成功",productTypeService.findList(productType));
    }
}
