package com.bcxin.rest.product.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.product.dao.ProductRelationDao;
import com.bcxin.models.product.entity.ProductRelation;
import com.bcxin.models.product.entity.ProductType;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.models.product.util.ProductTypeUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.Str2Utils;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * 产品查询接口
 * Created by playboy on 2017/6/5.
 */
@Controller
@RequestMapping(value = "${apiPath}/webProduct")
public class ProductApiController extends BaseController {

    /**
     * 保险产品服务
     */
    @Autowired
    ProductRelationService productRelationService;

    @Autowired
    ProductRelationDao productRelationDao;

    /**
     * 获取保险产品
     * @return
     */
    @RequestMapping(value = "/getProductList",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getProductInsList(@RequestParam String sign, String productId,String startDate,@RequestParam Integer productType){
        Map<String,Object> params = Maps.newHashMap();
        params.put("sign",sign);
        params.put("productId",productId);
        params.put("startDate",startDate);
        params.put("productType",productType);
        List<Map<String,Object>> list = productRelationService.getProductListDetails(params);
        return new AjaxResult(true,"请求成功", list);
    }

    /**
     * hxxt专用接口
     * 业务支撑 => 核心系统 获取产品列表  1_产品数据同步
     * @return
     */
    @RequestMapping(value = "/getProductListHXXT",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getProductListHXXT(String startDate){
        Map<String,Object> params = Maps.newHashMap();
        params.put("startDate",startDate);
        List<Map<String,Object>> list = productRelationService.selectToHxxt(params);
        List<Map<String,Object>> rtnList = Lists.newArrayList();
        for(Map<String,Object> map:list) {
            List<ProductType> pList = Lists.newArrayList();
            ProductType.sortList(pList, ProductTypeUtil.getProductTypeList(StrUtil.obj2Str(map.get("productType"))), StrUtil.toLong(map.get("typeId")));
            List<String> tempList = Lists.newArrayList();
            for(ProductType productType:pList){
                if(StrUtil.isNotBlank(productType.getTypeLevel())) {
                    tempList.add(productType.getTypeName());
                }
            }
            map.put("type", Str2Utils.arrayToString(Str2Utils.toStringArray(tempList),"-"));
            rtnList.add(map);

        }
        return new AjaxResult(true,"请求成功", list);
    }

    /**
     * hxxt专用
     * 获取产品关联
     * @return
     */
    @RequestMapping(value = "/getProductRelationListHXXT",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getProductRelationList(String startDate){
//        List<ProductRelation> list;
        Map p = Maps.newHashMap();
        p.put("startDate",startDate);
        List<Map> res = productRelationDao.selectProductRelation(p);
//        if(null!=startDate){
//            list = productRelationService.selectList(new EntityWrapper().addFilter("update_time>={0} and type in('1','2','4') ",startDate));
//        }else {
//            list = productRelationService.selectList(new EntityWrapper().addFilter("type in('1','2','4')  ",startDate));
//        }
        return new AjaxResult(true,"请求成功", res);
    }



    //@RequestMapping(value = "/test")
    public void test(String startDate){
        List<ProductRelation> list;
        if(null!=startDate){
            list = productRelationService.selectList(new EntityWrapper().addFilter("update_time>={0} and type in('1','2') and hxxt_id is null",startDate));
        }else {
            list = productRelationService.selectList(new EntityWrapper().addFilter("type in('1','2')  and hxxt_id is null",startDate));
        }
    }
}
