package com.bcxin.rest.fee.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 *
 * 结算单接口同步数据
 * Created by playboy on 2017/6/12.
 */
@Controller
@RequestMapping("${apiPath}/webFeeSettlement")
public class FeeSettlementController extends BaseController {

    @Autowired
    FeeSettlementService feeSettlementService;

    /**
     * 结算接收接口
     */
    @RequestMapping("/receiveFeeSettlementData")
    @ResponseBody
    public AjaxResult receiveFeeSettlementData(HttpServletRequest request){
        String data = request.getParameter("settlementData");
        if(StrUtil.isBlank(data)){
            return fail(false,"没有接收到数据");
        }
        List<FeeSettlement> feeSettlementList = Lists.newArrayList();
        List<Map<String,Object>> list = (List<Map<String, Object>>) JsonMapper.fromJsonString(data,List.class);
        for(Map<String,Object> map:list) {
            FeeSettlement feeSettlement= (FeeSettlement) JsonMapper.fromJsonString(JsonMapper.toJsonString(map),FeeSettlement.class);
            if(StrUtil.isBlank(beanValidatorAPI(feeSettlement))){
                FeeSettlement temp = feeSettlementService.selectOne(new EntityWrapper().addFilter("Hxxt_id={0}",feeSettlement.getHxxtId()));
                if(null!=temp){
                    feeSettlement.setId(temp.getId());
                    feeSettlement.setHxxtId(temp.getHxxtId());
                    feeSettlement.preUpdate();
                }else {
                    feeSettlement.preInsert();
                }
                feeSettlementList.add(feeSettlement);
            }
        }
        if(feeSettlementList.size()>0){
            feeSettlementService.insertOrUpdateBatch(feeSettlementList);
        }else {
            return fail(false,"保存失败");
        }
        return success(true,"保存成功["+feeSettlementList.size()+"]条数据.保存失败["+(list.size()-feeSettlementList.size())+"]条数据");
    }
}
