package com.bcxin.rest.fee.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.product.entity.ProductRelation;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 *
 *@Author:liyongqiang
 *@Description: 费率同步
 *@Date: 2017-08-31 18:00
 */
 
@Controller
@RequestMapping("${apiPath}/webFeeAgreement")
public class FeeAgreementController extends BaseController {

    @Autowired
    ProductRelationService productRelationService;

    /**
     * 一级费率接收接口 （只接收一级费率）
     */
    @RequestMapping("/receiveFeeAgreement")
    @ResponseBody
    public AjaxResult receiveFeeAgreement(HttpServletRequest request){
        String data = request.getParameter("feeAgreementData");
        if(StrUtil.isBlank(data)){
            return fail(false,"没有接收到数据");
        }
        List<ProductRelation>  relationList = Lists.newArrayList();
        List<Map<String,Object>> list = (List<Map<String, Object>>) JsonMapper.fromJsonString(data,List.class);
        for(Map<String,Object> map:list) {
            ProductRelation productRelation= (ProductRelation) JsonMapper.fromJsonString(JsonMapper.toJsonString(map),ProductRelation.class);
            if(StrUtil.isBlank(beanValidatorAPI(productRelation))){

                ProductRelation  temp=  productRelationService.selectOne(new EntityWrapper().addFilter("product_id={0} and relation_id={1} and type={2}",productRelation.getProductId(),productRelation.getRelationId(),productRelation.getType()));

                if(null!=temp){
                    productRelation.setId(temp.getId());
                    productRelation.preUpdate();
                }else {
                    productRelation.preInsert();
                }
                relationList.add(productRelation);
            }
        }
        if(relationList.size()>0){
            productRelationService.insertOrUpdateBatch(relationList);
        }else {
            return fail(false,"保存失败");
        }
        return success(true,"保存成功["+relationList.size()+"]条数据.保存失败["+(list.size()-relationList.size())+"]条数据");
    }
}
