package com.bcxin.rest.bill.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.core.util.SysLogUtils;
import com.bcxin.core.util.SysUserUtils;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.entity.FeeSettlementMonth;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.fee.service.IFeeSettlementMonthService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.models.order.service.OrderFormService;
import com.bcxin.models.order.service.impl.OrderFormServiceImpl;
import com.bcxin.models.product.util.SendEmailAndMsgUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 分销商账单
 *
 * @author lyq
 */
@Controller
@RequestMapping("${apiPath}/bill/")
public class BillController extends BaseController {


    //分销商账单列表
    private static final String DISTRIBUTOR_LIST = getViewPath("admin/fee/company/api/distributor_list");


    //分销商详细信息
    private static final String DISTRIBUTOR_DETAIL = getViewPath("admin/fee/company/api/distributor_detatil");


    //分销商未找到
    private static final String DISTRIBUTOR_NOT_FIND = getViewPath("admin/fee/company/api/404");

    @Autowired
    private OrderFormDao orderFormDao;

    @Autowired
    private SysCompanyService companyService;

    @Autowired
    private FeeSettlementService feeSettlementService;

    /**
     * 结算接收接口
     */
    @RequestMapping("/receiveFeeSettlementData")
    public String receiveFeeSettlementData(HttpServletRequest request, Model model) {
        String uid = request.getParameter("uid");
        if (StringUtils.isEmpty(uid)) {
            logger.info("uid 为空");
            return "redirect:/api/bill/noFind";
        }
        String distributorId = orderFormDao.findCompanyIDByID(uid);
        if (distributorId==null||"null".equals(distributorId) || "".equals(distributorId)) {
            logger.info("订单未找到归属的分销商");
            return "redirect:/api/bill/noFind";
        }
        //查找该分销商账号
        SysCompany  company=companyService.get(Long.parseLong(distributorId));
       if(company==null){
           logger.info("订单未查找该分销商账号");
           return "redirect:/api/bill/noFind";
       }
        SysUser user = new SysUser();
        user.setLoginName("培训账号");
        request.getSession().setAttribute("company", company);
        if (2 == company.getCompanyType()) {
            //分销商
            return DISTRIBUTOR_LIST;
        }
        if (4 == company.getCompanyType()) {
            //资源方
//            return RESOURCE_SIDE_LIST;
        }
        if (1 == company.getCompanyType()) {
            //供应商
//            return SUPPLY_LIST;
        }
        return "redirect:/api/bill/noFind";

    }


    @RequestMapping("/getDistributorListData")
    @ResponseBody
    public String getDistributorListData(HttpServletRequest request,Model model, FeeSettlement feeSettlement){
        SysCompany  company = (SysCompany) request.getSession().getAttribute("company");
        if(company==null){
            return "redirect:/api/bill/noFind";
        }
        Page<Map<String,String>> page =this.getPage();
        feeSettlement.setSysType(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        feeSettlement.setSysCompany(company);
        feeSettlementService.findOnePage(page,feeSettlement,feeSettlement.getSysType());
        return jsonPage(page);
    }


    /**
     * 查询明细
     *
     * @param model
     * @param id
     * @return
     */
    @RequestMapping("/getDetatilList/{id}")
    public String getDetatilList(Model model, @PathVariable Long id) {
        FeeSettlement fee = feeSettlementService.selectById(id);
        Map<String, String> feeMap = feeSettlementService.getFeeDetaitil(id);
        if (fee == null) {
            return "redirect:/api/bill/noFind";
        }
        model.addAttribute("fee", fee);
        model.addAttribute("feeMap", feeMap);
        return DISTRIBUTOR_DETAIL;

    }


    @RequestMapping("/noFind")
    public String noFind(Model model) {

        return DISTRIBUTOR_NOT_FIND;

    }




    @RequestMapping("/getOrderNum")
    @ResponseBody
    public Map<String,Object> getOrderNum(HttpServletRequest request,Model model,String companyId,FeeSettlement feeSettlement){
        SysCompany  company = (SysCompany) request.getSession().getAttribute("company");
        Map<String,Object> map= null;
        if(company==null){

            map.put("totalNum","0");
            map.put("totalMoney","0");
        }
        Map<String,Object> param=  new HashMap<>();
        param.put("sDate",feeSettlement.getsDate());
        param.put("eDate",feeSettlement.geteDate());
        param.put("sysCompanyId",company.getId());
        param.put("likeValue",feeSettlement.getLikeValue());
        map=feeSettlementService.findFeeSettlementTongJi(param);

        return map;
    }




}
