package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogDetailEntity;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class DeviceCommunicatedLogDetailUtils {
    public static Collection<DeviceCommunicatedLogDetailEntity> build(
            ConfigOfBillEntity config,
            IdWorker idWorker,
            Collection<RoomCommunicatedGroupDTO> communicatedGroups) {
        Collection<DeviceCommunicatedLogDetailEntity> deviceCommunicatedLogDetails = new ArrayList<>();
        for (RoomCommunicatedGroupDTO group : communicatedGroups) {
            /**
             * 调度方也生成一条记录
             */
            Collection<RoomCommunicatedGroupDTO.JoinRoomUserDto> joinRoomUsers =
                    group.getJoinRoomUsers().stream()
                            .filter(ix -> !ix.isCaller())
                            .collect(Collectors.toList());
            if (group.getAudioVideoLogs() == null) {
                continue;
            }

            CommunicatedType communicatedType = group.getCommunicatedType();
            for (RoomCommunicatedGroupDTO.AudioVideoLogDto audioVideoLog : group.getAudioVideoLogs()) {
                for (RoomCommunicatedGroupDTO.JoinRoomUserDto roomUser : joinRoomUsers) {
                    /**
                     * 根据被调度人加入和结束的时间来计算调度记录和联动值
                     */
                    DeviceCommunicatedLogDetailEntity logDetailEntity = null;
                    /**
                     * 如果是调度方（只会有一条记录）的话; 则生成一条记录
                     */
                    if (audioVideoLog.HasJoin(roomUser)) {
                        String logDetailDomainId = roomUser.getDomainId();
                        String logDetailDomainName = roomUser.getCompanyName();
                        logDetailEntity =
                                DeviceCommunicatedLogDetailEntity.create(
                                        config,
                                        group.getDeskType(),
                                        idWorker.getNextId(),
                                        String.valueOf(roomUser.getInvitedUserRecordId()),
                                        group.getRoomId(),
                                        audioVideoLog.getCommunicatedType(),
                                        group.getCallerEmployeeId(),
                                        group.getCallerEmployeeName(),
                                        group.getCallerDeviceNo(),
                                        group.getCallerCompanyName(),
                                        roomUser.getEmployeeId(),
                                        roomUser.getEmployeeName(),
                                        roomUser.getDeviceNo(),
                                        logDetailDomainName,
                                        group.getCallerCompanyId(),
                                        logDetailDomainId,
                                        audioVideoLog.getActuallyBeginJoinTime(roomUser),
                                        audioVideoLog.getActuallyEndJoinTime(roomUser),
                                        group.getReferenceType(),
                                        group.getReferenceNumber(),
                                        group.isCallerPayTheBill(),
                                        group.getCallerOrgInstitutional(),
                                        roomUser.getProjectId(),
                                        roomUser.getProjectName()
                                );
                    }

                    if (logDetailEntity != null) {
                        if (roomUser.isSuperviseRole()) {
                            logDetailEntity.cleanPoints();
                        }

                        deviceCommunicatedLogDetails.add(logDetailEntity);
                    }
                }
            }

            /**
             * 取其中的一条来计算未接听的连动值
             */
            DeviceCommunicatedLogDetailEntity firstCommunicatedLogDetail =
                    deviceCommunicatedLogDetails.stream().findFirst().orElse(null);
            for (RoomCommunicatedGroupDTO.NoAnswerRoomUserRecordDto answerRoomUserRecord : group.getNoAnswerRoomUsers()) {
                DeviceCommunicatedLogDetailEntity newCommunicatedLogDetail = null;
                String logDetailDomainId = answerRoomUserRecord.getDomainId();
                String logDetailDomainName = answerRoomUserRecord.getCompanyName();
                if (firstCommunicatedLogDetail != null) {
                    newCommunicatedLogDetail =
                            firstCommunicatedLogDetail.copy(
                                    config,
                                    answerRoomUserRecord.getReferenceNumber(),
                                    String.valueOf(answerRoomUserRecord.getId()),
                                    answerRoomUserRecord.getEmployeeId(),
                                    answerRoomUserRecord.getEmployeeName(),
                                    answerRoomUserRecord.getDeviceNo(),
                                    logDetailDomainName,
                                    logDetailDomainId,
                                    answerRoomUserRecord.getCreatedTime(), null
                            );
                } else {
                    /**
                     * 都无人接听; 则创建一条
                     */
                    newCommunicatedLogDetail = DeviceCommunicatedLogDetailEntity.create(
                            config,
                            group.getDeskType(),
                            idWorker.getNextId(),
                            String.valueOf(answerRoomUserRecord.getId()),
                            group.getRoomId(),
                            communicatedType,
                            group.getCallerEmployeeId(),
                            group.getCallerEmployeeName(),
                            group.getCallerDeviceNo(),
                            group.getCallerCompanyName(),
                            answerRoomUserRecord.getEmployeeId(),
                            answerRoomUserRecord.getEmployeeName(),
                            answerRoomUserRecord.getDeviceNo(),
                            logDetailDomainName,
                            group.getCallerCompanyId(),
                            logDetailDomainId,
                            answerRoomUserRecord.getCreatedTime(),
                            null,
                            group.getReferenceType(),
                            group.getReferenceNumber(),
                            group.isCallerPayTheBill(),
                            group.getCallerOrgInstitutional(),
                            answerRoomUserRecord.getProjectId(),
                            answerRoomUserRecord.getProjectName()
                    );
                }

                if (newCommunicatedLogDetail != null) {
                    deviceCommunicatedLogDetails.add(newCommunicatedLogDetail);
                }
            }
        }

        /**
         * 生产未接听的人员信息
         */

        return deviceCommunicatedLogDetails;
    }
}
