package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.domains.entities.RdProjectRoadmapEntity;
import com.bcxin.tenant.open.domains.repositories.ProjectRoadmapRepository;
import com.bcxin.tenant.open.domains.services.ProjectRoadmapService;
import com.bcxin.tenant.open.domains.services.commands.CreateProjectRoadmapCommand;
import com.bcxin.tenant.open.domains.services.commands.DeleteProjectRoadmapCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdateProjectRoadmapCommand;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.exceptions.ForbidTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class ProjectRoadmapServiceImpl implements ProjectRoadmapService {
    private final UnitWork unitWork;
    private final ProjectRoadmapRepository projectRoadmapRepository;
    private final JsonProvider jsonProvider;

    public ProjectRoadmapServiceImpl(UnitWork unitWork, ProjectRoadmapRepository projectRoadmapRepository, JsonProvider jsonProvider) {
        this.unitWork = unitWork;
        this.projectRoadmapRepository = projectRoadmapRepository;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void dispatch(CreateProjectRoadmapCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            String roadMapJson = this.jsonProvider.getJson(command.getRoadmap());
            String roadmapImageJson = this.jsonProvider.getJson(command.getRoadmapImage());

            RdProjectRoadmapEntity projectRoadmap =  RdProjectRoadmapEntity.create(
                    command.getName(),roadmapImageJson,roadMapJson,command.getProjectId(),
                    command.getOrganizationId(),command.getOrganizationName(),command.getOperatorId());
            this.projectRoadmapRepository.insert(projectRoadmap);

            this.unitWork.commit(tranId);
        } catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(UpdateProjectRoadmapCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            RdProjectRoadmapEntity projectRoadmap = this.projectRoadmapRepository.getById(command.getId());

            if(projectRoadmap==null) {
                throw new NoFoundTenantException();
            }

            String roadMapJson = this.jsonProvider.getJson(command.getRoadmap());
            String roadmapImageJson = this.jsonProvider.getJson(command.getRoadmapImage());
            projectRoadmap.change(command.getName(),roadmapImageJson,roadMapJson,command.getOperatorId());
            this.projectRoadmapRepository.update(projectRoadmap);
            this.unitWork.commit(tranId);
        } catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(DeleteProjectRoadmapCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            RdProjectRoadmapEntity projectRoadmap = this.projectRoadmapRepository.getById(command.getId());

            if(projectRoadmap==null) {
                throw new NoFoundTenantException();
            }

            if(!StringUtil.isEqual(projectRoadmap.getOrganizationId(),command.getOrganizationId())) {
                throw new ForbidTenantException("非本公司的路线图, 不允许删除");
            }

            projectRoadmap.delete(command.getOperatorId());
            this.projectRoadmapRepository.update(projectRoadmap);
            this.unitWork.commit(tranId);
        } catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }
}
