package com.bcxin.tenant.open.domains.services.commands.results;

import com.bcxin.tenant.open.infrastructures.commands.results.CommandResultAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class CancelRollCallEmployeeCommandResult extends CommandResultAbstract {
    private final Collection<CancelRollCallEmployeeCommandItem> items;

    public CancelRollCallEmployeeCommandResult(Collection<CancelRollCallEmployeeCommandItem> items) {
        this.items = items;
    }

    public static CancelRollCallEmployeeCommandResult create(Collection<CancelRollCallEmployeeCommandItem> items) {
        return new CancelRollCallEmployeeCommandResult(items);
    }

    @Getter
    public static class CancelRollCallEmployeeCommandItem
    {
        private final String rollCallEmployeeId;
        private final int rollCallStatus;

        public CancelRollCallEmployeeCommandItem(String rollCallEmployeeId, int rollCallStatuses) {
            this.rollCallEmployeeId = rollCallEmployeeId;
            this.rollCallStatus = rollCallStatuses;
        }

        public static CancelRollCallEmployeeCommandItem create(String rollCallEmployeeId, int rollCallStatuses) {
            return new CancelRollCallEmployeeCommandItem(rollCallEmployeeId, rollCallStatuses);
        }
    }
}
