package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import lombok.Getter;

import java.sql.Time;
import java.util.Collection;
import java.util.Date;

@Getter
public class UpdateRollCallPlanCommand extends CreateRollCallPlanCommand{
    private final Long id;

    public UpdateRollCallPlanCommand(Long id,String name, Date beginDate, Date endDate,
                                     Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                                     String superviseDepartName, Collection<String> stationTypes,
                                     Collection<Time> timers) {
        super(name, beginDate, endDate, repetitiveRules, superviseDepartId, superviseDepartName, stationTypes, timers);
        this.id = id;
    }

    public static UpdateRollCallPlanCommand create(Long id,String name, Date beginDate, Date endDate,
                                            Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                                            String superviseDepartName, Collection<String> stationTypes,
                                            Collection<Time> timers) {
        return new UpdateRollCallPlanCommand(id, name, beginDate, endDate, repetitiveRules, superviseDepartId, superviseDepartName, stationTypes, timers);
    }
}
