package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import lombok.Getter;

@Getter
public class UpdateEmployeeDutyAndLatLonCommand extends CommandAbstract {
    private final DutySignInType dutySignInType;
    private final GeoPointValueType geoPoint;
    private final String tenantUserId;

    public UpdateEmployeeDutyAndLatLonCommand(DutySignInType dutySignInType,
                                              GeoPointValueType geoPoint,
                                              String tenantUserId) {
        this.dutySignInType = dutySignInType;
        this.geoPoint = geoPoint;
        this.tenantUserId = tenantUserId;
    }

    public static UpdateEmployeeDutyAndLatLonCommand create(DutySignInType dutySignInType,
                                                            GeoPointValueType geoPoint,
                                                            String tenantUserId) {
        return new UpdateEmployeeDutyAndLatLonCommand(dutySignInType, geoPoint, tenantUserId);
    }
}
