package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class RefreshOrgPurseCacheCommand extends CommandAbstract {
    private final Collection<String> organizationIds;
    private final boolean fromAutoDetect;

    public RefreshOrgPurseCacheCommand(Collection<String> organizationIds, boolean fromAutoDetect) {
        this.organizationIds = organizationIds;
        this.fromAutoDetect = fromAutoDetect;
    }

    public static RefreshOrgPurseCacheCommand create(Collection<String> organizationIds, boolean fromAutoDetect) {
        return new RefreshOrgPurseCacheCommand(organizationIds, fromAutoDetect);
    }
}
