package com.bcxin.tenant.open.domains.services.commands;

import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Optional;

@Getter
public class CreateRoomCommandResponse {
    private final Long roomNo;
    private final Collection<CreateRoomCommandItem> roomItems;

    public String getCid(String employeeId) {
        if (!StringUtils.hasLength(employeeId)) {
            return null;
        }

        if (CollectionUtils.isEmpty(this.getRoomItems())) {
            return null;
        }

        Optional<CreateRoomCommandItem>
                roomCommandItemOptional =
                this.getRoomItems().stream()
                        .filter(ii -> ii.getEmployeeId().equalsIgnoreCase(employeeId))
                        .findFirst();

        if (roomCommandItemOptional.isPresent()) {
            return roomCommandItemOptional.get().getCid();
        }

        return null;
    }

    public CreateRoomCommandResponse(Long roomNo, Collection<CreateRoomCommandItem> roomItems) {
        this.roomNo = roomNo;
        this.roomItems = roomItems;
    }

    public static CreateRoomCommandResponse create(Long roomNo, Collection<CreateRoomCommandItem> roomItems) {
        return new CreateRoomCommandResponse(roomNo, roomItems);
    }

    @Getter
    public static class CreateRoomCommandItem
    {
        private final String employeeId;
        private final String tenantUserId;
        private final String cid;

        public CreateRoomCommandItem(String employeeId, String tenantUserId, String cid) {
            this.employeeId = employeeId;
            this.tenantUserId = tenantUserId;
            this.cid = cid;
        }

        public static CreateRoomCommandItem create(String employeeId, String tenantUserId, String cid) {
            return new CreateRoomCommandItem(employeeId, tenantUserId, cid);
        }
    }
}
