package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class CreateRollCallCommand extends CommandAbstract {
    private final Long rollCallPlanId;

    /**
     * 自动点名的时间点
     */
    private final String timeValue;
    private final Collection<String> superviseDepartIds;
    private final Collection<String> securityStationIds;
    private final Collection<String> stationTypes;

    private final DoActionOperatorCommandItem operator;


    public CreateRollCallCommand(Long rollCallPlanId,
                                 String timeValue,
                                 Collection<String> superviseDepartIds,
                                 Collection<String> securityStationIds,
                                 Collection<String> stationTypes,
                                 DoActionOperatorCommandItem operator
                                 ) {
        this.rollCallPlanId = rollCallPlanId;
        this.timeValue = timeValue;
        this.superviseDepartIds = superviseDepartIds;
        this.securityStationIds = securityStationIds;
        this.stationTypes = stationTypes;
        this.operator = operator;
    }

    public static CreateRollCallCommand create(Long rollCallPlanId,
                                               String timeValue,
                                               Collection<String> superviseDepartIds,
                                               Collection<String> securityStationIds,
                                               Collection<String> stationTypes,
                                               DoActionOperatorCommandItem operator) {
        return new CreateRollCallCommand(rollCallPlanId, timeValue, superviseDepartIds, securityStationIds, stationTypes, operator);
    }

    @Getter
    public static class DoActionOperatorCommandItem extends CommandAbstract {

        private final String actionOrgInstitutional;

        private final String actionOrganizationId;

        /**
         * 发起.点名轮换的组织名称
         */
        private final String actionOrganizationName;

        /**
         * 发起.点名轮换的人员Id
         */
        private final String actionEmployeeId;

        /**
         * 发起.点名轮换的人员名字
         */
        private final String actionEmployeeName;

        public DoActionOperatorCommandItem(
                String actionOrganizationId, String actionOrgInstitutional,
                String actionOrganizationName,
                String actionEmployeeId, String actionEmployeeName) {
            this.actionOrganizationId = actionOrganizationId;
            this.actionOrganizationName = actionOrganizationName;
            this.actionEmployeeId = actionEmployeeId;
            this.actionEmployeeName = actionEmployeeName;
            this.actionOrgInstitutional = actionOrgInstitutional;
        }

        public static DoActionOperatorCommandItem create(
                String actionOrganizationId,
                String actionOrgInstitutional,
                String actionOrganizationName,
                String actionEmployeeId,
                String actionEmployeeName
                ) {
            return new DoActionOperatorCommandItem(
                    actionOrganizationId,
                    actionOrgInstitutional,
                    actionOrganizationName,
                    actionEmployeeId,
                    actionEmployeeName);
        }

        @Override
        public void validate() {
            if (!StringUtils.hasLength(this.getActionOrganizationId())) {
                throw new ArgumentTenantException("操作组织不能为空");
            }

            if (!StringUtils.hasLength(this.getActionEmployeeId())) {
                throw new ArgumentTenantException("操作人为空");
            }
        }
    }
}
