package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class CheckStationRailWarningCommand extends CommandAbstract {
    private final Collection<StationEmployeeLocation> employeeLocations;

    public CheckStationRailWarningCommand(Collection<StationEmployeeLocation> employeeLocations) {
        this.employeeLocations = employeeLocations;
    }

    public static CheckStationRailWarningCommand create(Collection<StationEmployeeLocation> employeeLocations) {
        return new CheckStationRailWarningCommand(employeeLocations);
    }

    @Getter
    public static class StationEmployeeLocation implements Serializable {
        private final Collection<String> employeeIds;
        private final Timestamp eventTime;

        private final double latitude;
        private final double longitude;

        private final String country;
        private final String province;
        private final String city;
        private final String district;
        private final String street;
        private final String streetNum;
        private final String poiName;
        private final String cityCode;

        public StationEmployeeLocation(Collection<String> employeeIds, Timestamp eventTime, double latitude, double longitude,
                                       String country, String province, String city,
                                       String district, String street, String streetNum,
                                       String poiName, String cityCode) {
            this.employeeIds = employeeIds;
            this.eventTime = eventTime;
            this.latitude = latitude;
            this.longitude = longitude;
            this.country = country;
            this.province = province;
            this.city = city;
            this.district = district;
            this.street = street;
            this.streetNum = streetNum;
            this.poiName = poiName;
            this.cityCode = cityCode;
        }

        public static StationEmployeeLocation create(Collection<String> employeeIds,
                                                     Timestamp eventTime,
                                                     double latitude, double longitude,
                                                     String country, String province, String city,
                                                     String district, String street, String streetNum,
                                                     String poiName, String cityCode) {
            return new StationEmployeeLocation(employeeIds, eventTime, latitude, longitude, country, province, city, district, street, streetNum, poiName, cityCode);
        }

        @Override
        public String toString() {
            return String.format("emid=%s;latitude=%s;longitude=%s;street=%s;", employeeIds.stream().collect(Collectors.joining(",")), latitude, longitude, street);
        }
    }
}
