package com.bcxin.tenant.open.domains.services;

import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.entities.OrgPurseEntity;
import com.bcxin.tenant.open.domains.services.commands.GenerateMonthlyBillOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.services.commands.RechargeOrgPurseTransactionCommand;

import java.util.List;

public interface OrgPurseTransactionService {
    void dispatch(CreateOrgPurseTransactionCommand command);

    /**
     * 月度账单生成时触发
     * @param command
     */
    void dispatch(GenerateMonthlyBillOrgPurseTransactionCommand command);

    /**
     * 钱包充值时，月账单扣费
     * @param command
     */
    void monthlyBillCharge(RechargeOrgPurseTransactionCommand command);

    /**
     *月度账单自动扣费。更新企业钱包，月度账单状态，生成钱包交易记录及支付记录
     * @param billsList
     * @param orgPurse
     */
    void chargeOrganizationBills(List<MonthlyBillEntity> billsList, OrgPurseEntity orgPurse);
}
