package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.criterias.RollCallEmployeeCriteria;
import com.bcxin.tenant.open.domains.criterias.RollCallEmployeeGroupCriteria;
import com.bcxin.tenant.open.domains.dtos.RollCallEmployeeGroupSearchDTO;
import com.bcxin.tenant.open.domains.dtos.RollCallStatusDTO;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface RollCallEmployeeRepository extends RepositoryBase<RollCallEmployeeEntity> {
    void batchInsert(Collection<RollCallEmployeeEntity> data);

    Collection<RollCallEmployeeEntity> findByRollCallIdAndEmployeeIds(Long rollCallId, Collection<String> employeeIds);

    EntityCollection<RollCallEmployeeGroupSearchDTO> search(RollCallEmployeeGroupCriteria criteria);

    Collection<RollCallEmployeeEntity> search(RollCallEmployeeCriteria criteria);

    Collection<RollCallEmployeeEntity> getTopNCanBeExpiredRecords(int pageSize, RollCallStatus callStatus);

    Collection<RollCallEmployeeEntity> findByIds(Collection<String> ids);

    Collection<RollCallEmployeeEntity> findByRollCallIdsAndEmployeeIds(Collection<Long> rollCallIds, Collection<String> employeeIds);

    void batchUpdateStatusAndCId(Collection<RollCallEmployeeEntity> data);
}
