package com.bcxin.tenant.open.domains.events;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

@Getter
public class ValidSecurityStationChangedEvent extends ApplicationEvent {
    private final String stationId;
    private final String organizationId;

    public ValidSecurityStationChangedEvent(String stationId, String organizationId) {
        super(stationId);
        this.stationId = stationId;
        this.organizationId = organizationId;
    }

    public static ValidSecurityStationChangedEvent create(String stationId, String organizationId)
    {
        return new ValidSecurityStationChangedEvent(stationId, organizationId);
    }
}
