package com.bcxin.tenant.open.domains.events;
import lombok.Getter;

@Getter
public class SecurityStationNameChangedEvent extends DomainEventAbstract{
    private final String stationId;
    private final String organizationId;

    public SecurityStationNameChangedEvent(String stationId, String organizationId) {
        super(stationId);
        this.stationId = stationId;
        this.organizationId = organizationId;
    }


    public static SecurityStationNameChangedEvent create(String stationId, String organizationId) {
        return new SecurityStationNameChangedEvent(stationId, organizationId);
    }
}
