package com.bcxin.tenant.open.domains.events;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.infrastructures.events.IntegrationDomainEvent;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collection;

public class ProprietorCompanyChangedIntegrationEvent extends IntegrationDomainEvent {
    private final Collection<String> organizationIds;

    public ProprietorCompanyChangedIntegrationEvent(String eventName,Collection<String> organizationIds) {
        super(eventName);
        this.organizationIds = organizationIds;
    }

    public static ProprietorCompanyChangedIntegrationEvent create(Collection<String> organizationIds) {
        return new ProprietorCompanyChangedIntegrationEvent(KafkaConstants.TOPIC_DISPATCH_PROPRIETOR_COMPANY_CHANGED, organizationIds);
    }

    @Override
    public String getKey(JsonProvider jsonProvider) {
        return jsonProvider.getJson(this.organizationIds);
    }

    @Override
    public String getValue(JsonProvider jsonProvider) {
        return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(Timestamp.from(Instant.now()));
    }
}
