package com.bcxin.tenant.open.domains.events;

import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import lombok.Getter;

import java.util.Collection;

@Getter
public class PreparedRoomCommunicatedGroupEvent extends DomainEventAbstract {

    private final Collection<RoomCommunicatedGroupDTO> roomCommunicatedGroups;

    public PreparedRoomCommunicatedGroupEvent(Collection<RoomCommunicatedGroupDTO> roomCommunicatedGroups) {
        super(roomCommunicatedGroups);
        this.roomCommunicatedGroups = roomCommunicatedGroups;
    }

    public static PreparedRoomCommunicatedGroupEvent create(Collection<RoomCommunicatedGroupDTO> roomCommunicatedGroups) {
        return new PreparedRoomCommunicatedGroupEvent(roomCommunicatedGroups);
    }
}
