package com.bcxin.tenant.open.domains.events;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

@Getter
public class EmployeeStatusChangedEvent extends ApplicationEvent {
    private final String organizationId;
    private final String employeeId;

    public EmployeeStatusChangedEvent(String organizationId, String employeeId) {
        super(employeeId);
        this.organizationId = organizationId;
        this.employeeId = employeeId;
    }

    public static EmployeeStatusChangedEvent create(String organizationId, String employeeId) {
        return new EmployeeStatusChangedEvent(organizationId, employeeId);
    }
}
