package com.bcxin.tenant.open.domains.eventListeners;

import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.events.MonthlyBillGenerateEvent;
import com.bcxin.tenant.open.domains.repositories.MonthlyBillRepository;
import com.bcxin.tenant.open.domains.services.OrgPurseTransactionService;
import com.bcxin.tenant.open.domains.services.commands.GenerateMonthlyBillOrgPurseTransactionCommand;
import com.bcxin.tenant.open.infrastructures.components.RetryProvider;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class MonthlyBillGenerateListener_OrgPurseTransaction implements ApplicationListener<MonthlyBillGenerateEvent> {
    private final Logger logger = LoggerFactory.getLogger(PreparedRoomCommunicatedGroupListener_OrgPurseTransaction.class);
    private final OrgPurseTransactionService orgPurseTransactionService;
    private final MonthlyBillRepository monthlyBillRepository;
    private final RetryProvider retryProvider;

    public MonthlyBillGenerateListener_OrgPurseTransaction(OrgPurseTransactionService orgPurseTransactionService, MonthlyBillRepository monthlyBillRepository, RetryProvider retryProvider) {
        this.orgPurseTransactionService = orgPurseTransactionService;
        this.monthlyBillRepository = monthlyBillRepository;
        this.retryProvider = retryProvider;
    }

    @Override
    public void onApplicationEvent(MonthlyBillGenerateEvent event) {
        logger.info("{}月度账单自动扣费开始，时间：{}", event.getMonth(), LocalDateTime.now());
        orgPurseTransactionService.dispatch(GenerateMonthlyBillOrgPurseTransactionCommand.create(event.getMonth()));
        logger.info("{}月度账单自动扣费完成，时间：{}",event.getMonth(),LocalDateTime.now());
    }
}
