package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.utils.TencentConstants;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;
import java.sql.Timestamp;
import java.time.Instant;
import lombok.Data;

@TableName(value = "tencent_callback_logs")
@Data
public class TencentCallbackLogEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "event_group_id")
    private Long eventGroupId;

    @TableField(value = "event_type")
    private int eventType;

    @TableField(value = "callback_ts")
    private Long callbackTs;

    @TableField(value = "event_info")
    private String eventInfo;

    @TableField(value = "created_time", insertStrategy = FieldStrategy.NOT_EMPTY)
    private Timestamp createdTime;

    @TableField(value = "user_id")
    private String userId;

    @TableField(value = "room_id")
    private String roomId;

    @TableField(value = "sdk_app_id")
    private String sdkAppId;

    @TableField(value = "processed_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ProcessedStatus status;

    @TableField(value = "last_processed_time")
    private Timestamp lastProcessedTime;

    @TableField(value = "last_processed_result")
    private String lastProcessedResult;

    public TencentCallbackLogEntity() {

        this.setStatus(ProcessedStatus.Init);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static TencentCallbackLogEntity create(
            Long eventGroupId, int eventType,
            Long callbackTs, String eventInfo,
            String userId, String roomId,String sdkAppId) {
        TencentCallbackLogEntity callbackLog =
                new TencentCallbackLogEntity();
        callbackLog.setEventGroupId(eventGroupId);
        callbackLog.setCallbackTs(callbackTs);
        callbackLog.setEventGroupId(eventGroupId);
        callbackLog.setEventType(eventType);
        callbackLog.setEventInfo(eventInfo);
        callbackLog.setUserId(userId);
        callbackLog.setRoomId(roomId);
        callbackLog.setSdkAppId(sdkAppId);

        return callbackLog;
    }
}
