package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "tenant_employee_recently_attendances", autoResultMap = true)
@Data
public class TenantEmployeeRecentlyAttendanceEntity extends EntityAbstract {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RecordStatus recordStatus;

    @TableField(value = "tenant_employee_id")
    private String tenantEmployeeId;

    @TableField(value = "name")
    private String name;

    @TableField(value = "address")
    private String address;

    /**
     * 聚合计算的资源信息
     */
    @TableField(value = "calculated_resource_type")
    private int calculatedResourceType;

    @TableField(value = "created_time")
    private Timestamp createdTime;
}
