package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.StationType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "rd_station_devices",autoResultMap = true)
@Data
public class StationDeviceEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "id")
    private String id;

    @TableField(value = "station_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private StationType stationType;

    @TableField(value = "station_id")
    private String stationId;

    @TableField(value = "third_party_name")
    private String thirdPartyName;

    @TableField(value = "third_party_id")
    private String thirdPartyId;

    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;
}
