package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "security_station_rails_query_record")
@Data
public class SecurityStationRailQueryEntity extends EntityAbstract implements Aggregate {

    @TableField(value = "rail_id")
    private Long railId;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "created_time")
    private Timestamp createTime;

    public SecurityStationRailQueryEntity(){
        this.createTime = Timestamp.from(Instant.now());
    }

    public static SecurityStationRailQueryEntity create(Long railId, String organizationId){
        SecurityStationRailQueryEntity entity = new SecurityStationRailQueryEntity();
        entity.setRailId(railId);
        entity.setOrganizationId(organizationId);
        return entity;
    }
}
