package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.*;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;

@TableName(value = "vga_rooms")
@Data
public class RoomEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "begin_Time")
    private Timestamp beginTime;

    @TableField(value = "end_Time")
    private Timestamp endTime;

    @TableField(value = "is_activated")
    private Boolean activated;

    @TableField(value = "leave_time")
    private Timestamp leaveTime;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "employee_id")
    private String employeeId;

    @TableField(value = "is_tencent_closed")
    private Boolean tencentClosed;

    @TableField(value = "tencent_closed_time")
    private Timestamp tencentClosedTime;

    @TableField(value = "processed_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ProcessedStatus status;

    @TableField(value = "last_processed_time")
    private Timestamp lastProcessedTime;

    @TableField(value = "last_processed_result")
    private String lastProcessedResult;

    @TableField(value = "communicated_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private CommunicatedType communicatedType;

    @TableField(value = "yardman_type")
    private int yardmanType;

    /**
     * 调度原因
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DispatchReasonType referenceType;

    /**
     * 调度的引用Id
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    private Collection<RoomUserEntity> roomUsers;

    /**
     * 调度台类型
     */
    @TableField(value = "desk_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeskType deskType;


    public RoomEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setBeginTime(this.getCreatedTime());
        this.setActivated(true);
        this.setTencentClosed(false);
        this.setStatus(ProcessedStatus.Init);
    }

    public static RoomEntity create(Long id,CommunicatedType communicatedType,int yardmanType,
                                    String employeeId, String organizationId,
                                    DispatchReasonType referenceType,
                                    String referenceNumber,
                                    DeskType deskType) {
        RoomEntity room = new RoomEntity();
        room.setId(id);
        room.setEmployeeId(employeeId);
        room.setOrganizationId(organizationId);
        room.setCommunicatedType(communicatedType);
        room.setYardmanType(yardmanType);

        room.setReferenceType(referenceType);
        room.setReferenceNumber(referenceNumber);
        room.setDeskType(deskType);

        return room;
    }

    public void leave() {
        this.setActivated(false);
        this.setLeaveTime(Timestamp.from(Instant.now()));
    }

    public void addUser(Long id,
                        String employeeId,
                        String tenantUserId,
                        String employeeName,
                        String organizationId,
                        String organizationName,
                        String tencentUserId,
                        String securityStationId,
                        String securityStationName,
                        String superviseDepartId,
                        String cid,
                        boolean isSponsor,
                        boolean isSuperviseDepartRole) {
        Collection<RoomUserEntity> roomUsers = this.getRoomUsers();
        if (roomUsers == null) {
            roomUsers = new ArrayList<>();
        }

        roomUsers.add(
                RoomUserEntity.create(
                        this.getId(), id,
                        employeeId,
                        tenantUserId,
                        cid,
                        employeeName,
                        organizationId,
                        organizationName,
                        tencentUserId,
                        securityStationId,
                        securityStationName,
                        superviseDepartId,
                        isSponsor,
                        isSuperviseDepartRole)
        );

        this.setRoomUsers(roomUsers);
    }
}