package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;

/**
 * 点名计划详情
 */
@TableName(value = "vga_roll_call_plans",autoResultMap = true)
@Data
public class RollCallPlanEntity extends EntityAbstract implements Aggregate {
    @TableId("id")
    private Long id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "begin_date")
    private Date beginDate;

    @TableField(value = "end_date")
    private Date endDate;

    /**
     * 规则选项; 多选
     * 使用位移计算的方式
     */
    @TableField(value = "repetitive_rule")
    private int repetitiveRule;

    @TableField(value = "supervise_depart_id")
    private String superviseDepartId;

    @TableField(value = "supervise_depart_name")
    private String superviseDepartName;

    /**
     * 驻勤点类型; 采用json格式进行过滤
     */
    @TableField(value = "station_types")
    private String stationTypes;

    /**
     * 点名时间;
     * 列表
     * [{"id":1,"value":"12:00:01"},{"id":2,"value":"13:00:02"}]
     */
    @TableField(value = "periods_of_times")
    private String periodsOfTimes;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    /**
     * 创建该点名计划的组织
     */
    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "organization_institutional")
    private String organizationInstitutional;

    @TableField(value = "organization_name")
    private String organizationName;

    /**
     * 创建该点名计划的用户Id
     */
    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 创建该点名计划的用户名称
     */
    @TableField(value = "creator_name")
    private String creatorName;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    /**
     * 修改该点名计划的用户
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    @TableField(value = "last_updater_name")
    private String lastUpdaterName;

    @TableField(value = "deleted")
    private boolean deleted;

    @TableField(value = "deleted_time")
    private Timestamp deletedTime;

    /**
     * 该定义已经点名了多少次
     */
    @TableField(value = "count_of_instances")
    private int countOfInstances;

    public RollCallPlanEntity() {
        this.createdTime = Timestamp.from(Instant.now());
        this.deleted = false;
        this.countOfInstances = 0;
    }

    public void delete() {
        this.setDeleted(true);
        this.setDeletedTime(Timestamp.from(Instant.now()));
    }

    public void change(String name, Date beginDate, Date endDate,
                       Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                       String superviseDepartName, String stationTypes,
                       String periodsOfTimes,
                       String lastUpdaterId,
                       String lastUpdaterName) {
        this.setName(name);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setRepetitiveRule(RepetitiveRule.calculateRepetitiveRule(repetitiveRules));
        this.setSuperviseDepartId(superviseDepartId);
        this.setSuperviseDepartName(superviseDepartName);
        this.setStationTypes(stationTypes);
        this.setPeriodsOfTimes(periodsOfTimes);
        this.setLastUpdaterId(lastUpdaterId);
        this.setLastUpdaterName(lastUpdaterName);

        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }


    public void markDeleted() {
        this.setDeletedTime(Timestamp.from(Instant.now()));
        this.setDeleted(true);
    }

    public RollCallPlanEntity(Long id,
                              String name, Date beginDate, Date endDate,
                              Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                              String superviseDepartName, String stationTypes,
                              String periodsOfTimes,
                              String organizationId,
                              String organizationInstitutional,
                              String organizationName,
                              String creatorId, String creatorName) {
        super();

        this.id = id;
        this.name = name;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.repetitiveRule = RepetitiveRule.calculateRepetitiveRule(repetitiveRules);
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.stationTypes = stationTypes;
        this.periodsOfTimes = periodsOfTimes;
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.lastUpdatedTime = null;
        this.lastUpdaterId = null;
        this.lastUpdaterName = null;
        this.organizationId = organizationId;
        this.organizationInstitutional = organizationInstitutional;
        this.organizationName = organizationName;

        this.createdTime = Timestamp.from(Instant.now());
    }

    public static RollCallPlanEntity create(Long id,
                                            String name, Date beginDate, Date endDate,
                                            Collection<RepetitiveRule> repetitiveRules,
                                            String superviseDepartId,
                                            String superviseDepartName, String stationTypes,
                                            String periodsOfTimes,
                                            String organizationId,
                                            String organizationInstitutional,
                                            String organizationName,
                                            String creatorId, String creatorName) {
        return new RollCallPlanEntity(
                id,
                name, beginDate, endDate,
                repetitiveRules, superviseDepartId,
                superviseDepartName,
                stationTypes,
                periodsOfTimes,
                organizationId,
                organizationInstitutional,
                organizationName,
                creatorId, creatorName);
    }
}
