package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.enums.EventSourceType;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "rd_sync_events",autoResultMap = true)
@Data
public class RdSyncEventEntity extends RdSuperviseEntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField("id")
    private String id;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT,
            javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ProcessedStatus status;

    @TableField("last_processed_result")
    private String lastProcessedResult;

    @TableField("last_processed_time")
    private Timestamp lastProcessedTime;

    @TableField("created_time")
    private Timestamp createdTime;

    @TableField(value = "source_type", jdbcType = JdbcType.TINYINT,
            javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private EventSourceType sourceType;
}
