package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailBusinessType;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Set;

@Data
@TableName(value = "rd_security_station_rail_messages",autoResultMap = true)
public class RdSecurityStationRailMessageEntity extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "employee_id")
    private String employeeId;

    @TableField(value = "employee_name")
    private String employeeName;

    @TableField(value = "employee_idCard_no")
    private String employeeIdCardNo;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "company_name")
    private String companyName;

    @TableField(value = "log_lat_json")
    private String logLatJson;

    @TableField(value = "station_rail_id")
    private Long stationRailId;

    /**
     * 围栏名称
     */
    @TableField(value = "station_rail_name")
    private String stationRailName;

    @TableField(value = "rail_rule_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailRuleType railRuleType;

    @TableField(value = "rail_shape_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailShapeType railShapeType;
    @TableField(value = "rail_business_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailBusinessType railBusinessType;
    @TableField("rail_area_json")
    private String railAreaJson;

    /**
     * 驻勤点id
     */
    @TableField("rail_reference_number")
    private String railReferenceNumber;

    /**
     * 驻勤点名称
     */
    @TableField("rail_reference_name")
    private String railReferenceName;

    /**
     * 驻勤点地址
     */
    @TableField("rail_reference_address")
    private String railReferenceAddress;

    /**
     * 监管归属
     */
    @TableField("rail_reference_supervise_depart_id")
    private String railReferenceSuperviseDepartId;

    /**
     * 监管归属
     */
    @TableField("rail_reference_supervise_depart_name")
    private String railReferenceSuperviseDepartName;

    @TableField(value = "event_time")
    private Timestamp eventTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    /**
     * 聚合计算的资源信息
     */
    @TableField(value = "calculated_resource_type")
    private int calculatedResourceType;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "project_name")
    private String projectName;

    public RdSecurityStationRailMessageEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RdSecurityStationRailMessageEntity create(
            Long pkId,
            Timestamp eventTime,
            String employeeId,
            String employeeName,
            String organizationId,String companyName,
            String logLatJson,Long stationRailId,String stationRailName,
            RailRuleType railRuleType,RailShapeType railShapeType,
            RailBusinessType railBusinessType,String railAreaJson,
            String railReferenceNumber,String railReferenceName,
            String railReferenceAddress,
            String railReferenceSuperviseDepartId,
            String railReferenceSuperviseDepartName,
            String employeeIdCardNo,
            Set<ResourceType> resourceTypes
    ) {
        RdSecurityStationRailMessageEntity railMessage = new RdSecurityStationRailMessageEntity();
        railMessage.setPkId(pkId);
        railMessage.setEventTime(eventTime);
        railMessage.setRailReferenceAddress(railReferenceAddress);
        railMessage.setRailReferenceSuperviseDepartId(railReferenceSuperviseDepartId);
        railMessage.setRailReferenceSuperviseDepartName(railReferenceSuperviseDepartName);

        railMessage.setEmployeeId(employeeId);
        railMessage.setEmployeeName(employeeName);
        railMessage.setOrganizationId(organizationId);
        railMessage.setCompanyName(companyName);
        railMessage.setLogLatJson(logLatJson);
        railMessage.setStationRailId(stationRailId);
        railMessage.setStationRailName(stationRailName);

        railMessage.setRailRuleType(railRuleType);
        railMessage.setRailShapeType(railShapeType);
        railMessage.setRailBusinessType(railBusinessType);
        railMessage.setRailAreaJson(railAreaJson);
        railMessage.setRailReferenceNumber(railReferenceNumber);
        railMessage.setRailReferenceName(railReferenceName);
        railMessage.setEmployeeIdCardNo(employeeIdCardNo);
        railMessage.setCalculatedResourceType(ResourceType.getCalculatedResourceValue(resourceTypes));

        return railMessage;
    }
}
