package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.Sex;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "rd_project_team_member_summary",autoResultMap = true)
@Data
public class RdProjectTeamMemberEntity extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "idCard_no")
    private String idCardNo;

    @TableField(value = "contact")
    private String contact;

    @TableField(value = "person_type")
    private String personType;

    @TableField(value = "employee_id")
    private String employeeId;

    @TableField(value = "sex", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private Sex sex;

    @TableField(value = "project_team_group_id")
    private String projectTeamGroupId;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "company_name")
    private String companyName;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;
}
