package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class SponsorDispatchLogSearchCriteria extends CriteriaAbstract {
    private final Collection<String> employeeIds;
    private final Date beginDate;
    private final Date endDate;

    public SponsorDispatchLogSearchCriteria(Collection<String> employeeIds, Date beginDate, Date endDate) {
        this.employeeIds = employeeIds;
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public static SponsorDispatchLogSearchCriteria create(Collection<String> employeeIds, Date beginDate, Date endDate) {
        return new SponsorDispatchLogSearchCriteria(employeeIds, beginDate, endDate);
    }
}
