package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class RollCallPlanSearchCriteria extends CriteriaAbstract {
    private final String name;
    private final Collection<String> superviseDepartIds;

    private final Collection<String> stationTypes;

    public RollCallPlanSearchCriteria(int pageIndex, int pageSize,String name, Collection<String> superviseDepartIds,Collection<String> stationTypes) {
        super(pageIndex, pageSize);
        this.name = name;
        this.superviseDepartIds = superviseDepartIds;
        this.stationTypes = stationTypes;
    }

    public static RollCallPlanSearchCriteria create(int pageIndex, int pageSize,String name, Collection<String> superviseDepartIds,Collection<String> stationTypes) {
        return new RollCallPlanSearchCriteria(pageIndex, pageSize,name, superviseDepartIds,stationTypes);
    }
}
