package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class RollCallEmployeeCriteria extends CriteriaAbstract {
    private final Date beginDate;
    private final Date endDate;
    private final String calledEmployeeId;

    private final String rollCallId;

    private final Collection<RollCallType> callTypes;

    private final Collection<RollCallStatus> callStatuses;

    private final String actionOrganizationId;

    private final String securityStationId;

    public RollCallEmployeeCriteria(
            int pageIndex,
            int pageSize,
            Date beginDate, Date endDate,
            String calledEmployeeId,
            String rollCallId,
            Collection<RollCallType> callTypes,
            Collection<RollCallStatus> callStatuses,
            String actionOrganizationId,
            String securityStationId) {
        super(pageIndex, pageSize);
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.calledEmployeeId = calledEmployeeId;
        this.rollCallId = rollCallId;
        this.callTypes = callTypes;
        this.callStatuses = callStatuses;
        this.actionOrganizationId = actionOrganizationId;
        this.securityStationId = securityStationId;
    }


    public static RollCallEmployeeCriteria create(
            int pageIndex,
            int pageSize,
            String calledEmployeeId,Date beginDate,Date endDate,
            String rollCallId,
            Collection<RollCallType> callTypes,
            Collection<RollCallStatus> callStatuses,
            String actionOrganizationId,
            String securityStationId) {
        RollCallEmployeeCriteria criteria = new RollCallEmployeeCriteria(
                pageIndex, pageSize,
                beginDate, endDate, calledEmployeeId, rollCallId, callTypes, callStatuses,
                actionOrganizationId,securityStationId);

        return criteria;
    }
}
