package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

@Getter
public class RdSecurityStationRailMessageCriteria extends CriteriaAbstract {
    private Collection<DeskType> deskTypes;
    private final String employeeName;
    private final String companyName;
    private final String projectName;
    private final String railReferenceName;
    private final Collection<String> superviseDepartIds;
    private final Date eventStartDate;
    private final Date eventEndDate;
    private final String employeeIdCardNo;
    private final Collection<String> currentSuperviseDepartIds;
    private final Collection<String> organizationIds;


    public RdSecurityStationRailMessageCriteria(
            Collection<DeskType> deskTypes,
            String employeeName, String companyName, String railReferenceName,String projectName,
                                                Collection<String> superviseDepartIds, Date eventStartDate, Date eventEndDate,
                                                String employeeIdCardNo, int pageIndex, int pageSize, Collection<String> currentSuperviseDepartIds,
                                                Collection<String> organizationIds) {

        super(pageIndex, pageSize);

        this.deskTypes = deskTypes;
        this.employeeName = employeeName;
        this.companyName = companyName;
        this.railReferenceName = railReferenceName;
        this.superviseDepartIds = superviseDepartIds;
        this.eventStartDate = eventStartDate;
        this.eventEndDate = eventEndDate;
        this.employeeIdCardNo = employeeIdCardNo;
        this.currentSuperviseDepartIds = currentSuperviseDepartIds;
        this.organizationIds = organizationIds;
        this.projectName = projectName;
    }

    public static RdSecurityStationRailMessageCriteria create(
            Collection<DeskType> deskTypes,
            String employeeName, String companyName,String projectName,
                                                              String railReferenceName, Collection<String> superviseDepartIds,
                                                              Date eventStartDate, Date eventEndDate, String employeeIdCardNo,
                                                              int pageIndex, int pageSize, Collection<String> currentSuperviseDepartIds,
                                                              String[] organizationIds) {
        return new RdSecurityStationRailMessageCriteria(
                deskTypes,
                employeeName, companyName, railReferenceName,projectName, superviseDepartIds,
                eventStartDate, eventEndDate, employeeIdCardNo, pageIndex, pageSize, currentSuperviseDepartIds,
                organizationIds == null ? null : Arrays.stream(organizationIds).toList());
    }
}
