package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class ProjectRoadmapCriteria extends CriteriaAbstract {
    private final String name;
    private final String organizationName;
    private final Collection<String> projectIds;

    public ProjectRoadmapCriteria(int pageIndex, int pageSize,String name, String organizationName, Collection<String> projectIds) {
        super(pageIndex,pageSize);
        this.name = name;
        this.organizationName = organizationName;
        this.projectIds = projectIds;
    }

    public static ProjectRoadmapCriteria create(int pageIndex, int pageSize,String name,String organizationName, Collection<String> projectIds){
        return new ProjectRoadmapCriteria(pageIndex,pageSize,name,organizationName,projectIds);
    }
}
