package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Date;

@Getter
public class PoliceIncidentRegionReportCriteria extends CriteriaAbstract {
    private final String regionName;

    private final Date beginDate;

    public PoliceIncidentRegionReportCriteria(String regionName,Date beginDate) {

        this.regionName = regionName;
        this.beginDate = beginDate;
    }

    public static PoliceIncidentRegionReportCriteria create(String regionName,Date beginDate) {
        return new PoliceIncidentRegionReportCriteria(regionName,beginDate);
    }
}
