package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

@Getter
public class AttendanceCriteria extends CriteriaAbstract {
    private final String name;
    private final String companyName;
    private final String securityStationName;
    private final Collection<String> superviseDepartIds;
    private final Date createdStarDate;
    private final Date createdEndDate;
    private final String idCardNo;
    private final boolean supervise;
    private final Collection<String> organizationIds;

    private final Collection<String> projectIds;

    private final SearchModel searchModel;

    /**
     * 其他特殊权限范围: 驻勤点权限
     */
    private Collection<String> otherSpecialPermissionScopeIds;

    /**
     * 所关联的项目Id
     */
    private Collection<String> managedProjectIds;

    private boolean hasManagedProjectIds;

    public AttendanceCriteria(String name,
                              String companyName,
                              String securityStationName,
                              Collection<String> organizationIds,
                              boolean supervise,
                              Collection<String> superviseDepartIds,
                              Date createdStarDate,
                              Date createdEndDate,
                              String idCardNo,
                              Collection<String> projectIds,
                              int pageIndex,
                              int pageSize, SearchModel searchModel) {
        super(pageIndex, pageSize);
        this.name = name;
        this.companyName = companyName;
        this.securityStationName = securityStationName;
        this.superviseDepartIds = superviseDepartIds;
        this.createdStarDate = createdStarDate;
        this.createdEndDate = createdEndDate;
        this.idCardNo = idCardNo;
        this.searchModel = searchModel;
        this.supervise = supervise;
        this.organizationIds = organizationIds;
        this.projectIds = projectIds;
    }

    public void assignManagedProjectIds(
            Collection<String> managedProjectIds,
                                        Collection<String> otherSpecialPermissionScopeIds) {
        this.otherSpecialPermissionScopeIds = otherSpecialPermissionScopeIds;
        this.managedProjectIds = managedProjectIds;
        this.hasManagedProjectIds = !CollectionUtils.isEmpty(this.managedProjectIds);
    }

    public static AttendanceCriteria create(String name,
                                            String companyName,
                                            String securityStationName,
                                            String[] organizationIds,
                                            boolean supervise,
                                            Collection<String> superviseDepartIds,
                                            Date createdStarDate,
                                            Date createdEndDate,
                                            String idCardNo,
                                            Collection<String> projectIds,
                                            int pageIndex,
                                            int pageSize,
                                            SearchModel searchModel) {
        return new AttendanceCriteria(name,
                companyName,
                securityStationName,
                organizationIds==null? Collections.EMPTY_LIST: Arrays.stream(organizationIds).toList(),
                supervise,
                superviseDepartIds,
                createdStarDate,
                createdEndDate,
                idCardNo,
                projectIds,
                pageIndex,
                pageSize,
                searchModel);
    }

    public static enum SearchModel {
        AdvanceSearch,
        Today,
        RecentWeek,
        RecentMonth
    }
}
