package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;

@Getter
public class AttendanceAdvanceCriteria extends CriteriaAbstract {
    private final Collection<DeskType> deskTypes;
    private final String name;
    private final String companyName;
    private final String projectName;

    private final String projectCompanyName;
    private final String securityStationName;
    private final Collection<String> superviseDepartIds;
    private final Date createdStarDate;
    private final Date createdEndDate;
    private final String idCardNo;
    /**
     * 集团的情况会有多个organizationId(子公司的id)
     */
    private final Collection<String> organizationIds;

    private final Collection<Integer> recordStatuses;

    private final Boolean hasSecurityCertificateNo;
    /**
     * 其他特殊权限范围: 驻勤点权限
     */
    private Collection<String> otherSpecialPermissionScopeIds;

    /**
     * 所关联的项目Id
     */
    private Collection<String> managedProjectIds;

    private boolean hasManagedProjectIds;

    private Integer calculatedResourceType;

    public AttendanceAdvanceCriteria(
            int pageIndex,
            int pageSize,
            Collection<DeskType> deskTypes,
            String name, String companyName,String projectName,
            String projectCompanyName,
            String securityStationName,
            Collection<String> superviseDepartIds,
            Date createdStarDate, Date createdEndDate,
            String idCardNo, Collection<String> organizationIds,
            Boolean hasSecurityCertificateNo,
            Collection<RecordStatus> recordStatuses,
            Collection<String> otherSpecialPermissionScopeIds,
            Integer calculatedResourceType,
            Collection<String> managedProjectIds) {
        super(pageIndex, pageSize);

        this.deskTypes = deskTypes;
        this.name = name;
        this.companyName = companyName;
        this.securityStationName = securityStationName;
        this.superviseDepartIds = superviseDepartIds;
        this.createdStarDate = createdStarDate;
        this.createdEndDate = createdEndDate;
        this.idCardNo = idCardNo;
        this.organizationIds = organizationIds;
        if (CollectionUtils.isEmpty(recordStatuses)) {
            this.recordStatuses = Collections.EMPTY_LIST;
        } else {
            this.recordStatuses = recordStatuses.stream().map(ii -> ii.ordinal()).collect(Collectors.toList());
        }
        this.hasSecurityCertificateNo = hasSecurityCertificateNo;
        this.otherSpecialPermissionScopeIds = otherSpecialPermissionScopeIds;
        this.calculatedResourceType = calculatedResourceType;
        this.projectName = projectName;
        this.projectCompanyName = projectCompanyName;

        this.managedProjectIds = managedProjectIds;

        this.hasManagedProjectIds = !CollectionUtils.isEmpty(this.managedProjectIds);
    }

    public static AttendanceAdvanceCriteria create(int pageIndex,
                                                   int pageSize,
                                                   Collection<DeskType> deskTypes,
                                                   String name, String companyName,String projectName,
                                                   String projectCompanyName,
                                                   String securityStationName,
                                                   Collection<String> superviseDepartIds,
                                                   Date createdStarDate, Date createdEndDate,
                                                   String idCardNo, Collection<String> organizationIds,
                                                   Boolean hasSecurityCertificateNo,
                                                   Collection<RecordStatus> recordStatuses,
                                                   Collection<String> otherSpecialPermissionScopeIds,
                                                   Integer calculatedResourceType,
                                                   Collection<String> managedProjectIds) {
        return new AttendanceAdvanceCriteria(pageIndex, pageSize, deskTypes,name, companyName, projectName,projectCompanyName,securityStationName, superviseDepartIds,
                createdStarDate, createdEndDate, idCardNo,
                organizationIds,
                hasSecurityCertificateNo, recordStatuses,
                otherSpecialPermissionScopeIds,calculatedResourceType,managedProjectIds);
    }
}
