/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.jdks.requests.SecurityStationReaderRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Set;

@Schema(name="SecurityStationOverviewReaderResponse", title="SecurityStationOverviewReaderResponse \u9a7b\u52e4\u5217\u8868\u57fa\u672c\u4fe1\u606f")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SecurityStationOverviewReaderResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u9a7b\u52e4\u70b9Id")
    private final String id;
    @Schema(name="name", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String name;
    @Schema(name="organizationId", title="\u4f01\u4e1aId")
    private final String organizationId;
    @Schema(name="companyName", title="\u4f01\u4e1a\u540d\u79f0")
    private final String companyName;
    @Schema(name="latitude", title="\u9a7b\u52e4\u70b9\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u9a7b\u52e4\u70b9\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="address", title="\u9a7b\u52e4\u5730\u5740")
    private final String address;
    @Schema(name="stationTypes", title="\u9a7b\u52e4\u70b9\u7c7b\u578b; \u8fd4\u56de\u9a7b\u52e4\u7f16\u7801; \u524d\u7aef\u6839\u636e/station-types\u8fd4\u56de\u7684API\u6570\u636e\u8fdb\u884c\u6e32\u67d3")
    private final Collection<String> stationTypes;
    @Schema(name="superviseDepartId", title="\u6240\u5728\u9a7b\u52e4\u7684\u76d1\u7ba1\u5f52\u5c5e\u4fe1\u606f")
    private final String superviseDepartId;
    private final Set<String> followedDeviceNos;
    @Schema(name="isFollowed", title="\u662f\u5426\u5173\u6ce8")
    private final Boolean followed;
    @Schema(name="superviseDepartId", title="\u8d1f\u8d23\u4eba")
    private final String principalName;
    @Schema(name="projectId", title="\u4e34\u4fdd\u9879\u76eeId")
    private final String projectId;
    @Schema(name="projectName", title="\u4e34\u4fdd\u9879\u76ee")
    private final String projectName;
    @Schema(name="superviseDepartId", title="\u9a7b\u52e4\u4eba\u6570")
    private final Integer countOfSecurityMan;
    @Schema(name="rts", title="\u8d44\u6e90\u7c7b\u578b: Security=\u9a7b\u52e4\u70b9;Population=\u793e\u533a\u8b66\u52a1;Proprietor=\u5185\u4fdd\u5355\u4f4d\u7684\u4e1c\u897f\uff08\u6682\u65e0\uff09;ProprietorManaged=\u5185\u4fdd\u5355\u4f4d\u7ba1\u7406\u7684\u9a7b\u52e4\u70b9")
    private final Set<String> rts;

    public SecurityStationOverviewReaderResponse(SecurityStationReaderRequest.SearchModel mode, String id, String name, String organizationId, String companyName, Double latitude, Double longitude, String address, Collection<String> stationTypes, String superviseDepartId, Set<String> followedDeviceNos, boolean followed, String principalName, Integer countOfSecurityMan, Set<String> resourceTypes, String projectId, String projectName) {
        this.id = id;
        this.projectId = projectId;
        this.projectName = projectName;
        if (BusinessConstants.INVALID_LON_LAT == latitude || BusinessConstants.INVALID_LON_LAT == longitude) {
            this.latitude = null;
            this.longitude = null;
        } else {
            this.latitude = latitude;
            this.longitude = longitude;
        }
        this.stationTypes = stationTypes;
        this.rts = resourceTypes;
        if (mode != SecurityStationReaderRequest.SearchModel.SecurityResource) {
            this.name = name;
            this.companyName = companyName;
            this.organizationId = organizationId;
            this.countOfSecurityMan = countOfSecurityMan;
            this.address = address;
            this.superviseDepartId = superviseDepartId;
            this.followedDeviceNos = followedDeviceNos;
            this.followed = followed;
            this.principalName = principalName;
        } else {
            this.name = null;
            this.companyName = null;
            this.address = null;
            this.superviseDepartId = null;
            this.followedDeviceNos = null;
            this.followed = null;
            this.principalName = null;
            this.organizationId = null;
            this.countOfSecurityMan = null;
        }
    }

    public static SecurityStationOverviewReaderResponse create(SecurityStationReaderRequest.SearchModel mode, String id, String name, String organizationId, String companyName, Double latitude, Double longitude, String address, Collection<String> stationTypes, String superviseDepartId, Set<String> followedDeviceNos, boolean followed, String principalName, Integer countOfSecurityMan, Set<String> resourceTypes, String projectId, String projectName) {
        return new SecurityStationOverviewReaderResponse(mode, id, name, organizationId, companyName, latitude, longitude, address, stationTypes, superviseDepartId, followedDeviceNos, followed, principalName, countOfSecurityMan, resourceTypes, projectId, projectName);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getAddress() {
        return this.address;
    }

    public Collection<String> getStationTypes() {
        return this.stationTypes;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public Boolean getFollowed() {
        return this.followed;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Integer getCountOfSecurityMan() {
        return this.countOfSecurityMan;
    }

    public Set<String> getRts() {
        return this.rts;
    }
}

