/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.jdks.requests.EmployeeSearchRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

@Schema(name="EmployeeOverviewResponse", title="EmployeeOverviewResponse \u4fdd\u5b89\u5458\u5217\u8868\u7684\u57fa\u672c\u4fe1\u606f")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EmployeeOverviewResponse
extends ResponseAbstract {
    @Schema(name="id", title="2.\u4fdd\u5b89\u5458id")
    private final String id;
    @Schema(name="name;", title="\u4fdd\u5b89\u5458\u59d3\u540d")
    private final String name;
    @Schema(name="idCardNo", title="\u4fdd\u5b89\u5458\u8eab\u4efd\u8bc1")
    private final String idCardNo;
    @Schema(name="contact", title="\u4fdd\u5b89\u5458\u8054\u7cfb\u65b9\u5f0f")
    private final String contact;
    @Schema(name="dutyStatus", title="\u4fdd\u5b89\u5458\u7b7e\u5230\u72b6\u6001; None: \u79bb\u5c97(\u672a\u7b7e\u5230/\u79bb\u5f00\u9a7b\u52e4\u70b9); SignIn: \u5728\u5c97; SignOut: \u79bb\u5c97(\u7b7e\u9000/\u79bb\u5f00\u9a7b\u52e4\u70b9)")
    private final DutySignInType dutyStatus;
    @Schema(name="dutyStatusText", title="\u7b7e\u5230\u7684\u6587\u672c\u63cf\u8ff0; \u4fdd\u5b89\u5458\u7b7e\u5230\u72b6\u6001; None: \u79bb\u5c97(\u672a\u7b7e\u5230/\u79bb\u5f00\u9a7b\u52e4\u70b9); SignIn: \u5728\u5c97; SignOut: \u79bb\u5c97(\u7b7e\u9000/\u79bb\u5f00\u9a7b\u52e4\u70b9)")
    private String dutyStatusText;
    @Schema(name="securityStationId", title="\u9a7b\u52e4\u70b9Id")
    private final String securityStationId;
    @Schema(name="securityStationName", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String securityStationName;
    @Schema(name="organizationId", title="\u4f01\u4e1aorganizationId")
    private final String organizationId;
    @Schema(name="companyName", title="\u6240\u5728\u516c\u53f8")
    private final String companyName;
    @Schema(name="latitude", title="\u4fdd\u5b89\u5458\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u4fdd\u5b89\u5458\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="tencentUserId", title="\u97f3\u89c6\u9891\u7684\u817e\u8bafUserId")
    private final String tencentUserId;
    @Schema(name="tenantImUserId", title="\u7528\u6237\u672c\u8eab\u7684\u817e\u8bafUserId")
    private final String tenantImUserId;
    @Schema(name="cid", title="APP\u8bbe\u5907Cid\u7684\u503c")
    private final String cid;
    @Schema(name="isDevice", title="\u662f\u5426\u4e3a\u786c\u4ef6\u8bbe\u5907")
    private final Boolean isDevice;
    private final Set<String> followedDeviceNos;
    @Schema(name="isFollowed", title="\u662f\u5426\u5173\u6ce8")
    private final Boolean followed;
    @Schema(name="hasResource", title="\u662f\u5426\u5177\u6709\u8c03\u5ea6\u8d44\u6e90")
    private Boolean hasResource;
    @Schema(name="superviseDepartId", title="\u6240\u5c5e\u76d1\u7ba1\u5f52\u5c5eId")
    private final String superviseDepartId;
    @Schema(name="stationResponsible", title="\u662f\u5426\u4e3a\u9a7b\u52e4\u70b9\u8d1f\u8d23\u4eba")
    private final boolean stationResponsible;
    @Schema(name="responsibleOfStationId", title="\u6240\u8d1f\u8d23\u7684\u9a7b\u52e4\u70b9Id")
    private final String responsibleOfStationId;
    @Schema(name="rts", title="\u8d44\u6e90\u7c7b\u578b: Security=\u4fdd\u5b89;Population=\u793e\u4f1a\u529b\u91cf;Proprietor=\u5185\u4fdd\u5355\u4f4d\u7684\u7532\u65b9\u7ba1\u7406\u5458;ProprietorManaged=\u5185\u4fdd\u5355\u4f4d\u7ba1\u7406\u7684\u4fdd\u5b89\u4eba\u5458")
    private final Set<String> rts;
    @Schema(name="proprietorCompanyId", title="\u6240\u670d\u52a1\u7684\u5185\u4fdd\u5355\u4f4dId")
    private final String proprietorCompanyId;
    @Schema(name="proprietorCompanyName", title="\u6240\u670d\u52a1\u7684\u5185\u4fdd\u5355\u4f4d\u4fe1\u606f")
    private final String proprietorCompanyName;
    @JsonIgnore
    private EmployeeSearchRequest.SearchModel searchModel;
    @Schema(name="projectName", title="\u9879\u76ee\u540d\u79f0")
    private final String projectName;
    @Schema(name="stationType", title="\u6240\u5728\u5c97\u70b9\u7684\u7c7b\u578b: \u6bd4\u5982\uff1a\u9a6c\u62c9\u677e\u4e2d, \u6b64\u503c\u4f5c\u4e3a\u5de5\u4f5c\u4eba\u5458\u7c7b\u578b\u7684Id;\u53ef\u4ee5\u7528\u4e8e\u83b7\u53d6\u5de5\u4f5c\u7c7b\u578b\u7684\u540d\u79f0")
    private final String stationType;

    public Boolean getIsDevice() {
        if (this.getSearchModel() == EmployeeSearchRequest.SearchModel.SecurityResource) {
            return null;
        }
        return this.isDevice;
    }

    public EmployeeOverviewResponse(EmployeeSearchRequest.SearchModel searchMode, String id, String organizationId, String name, String idCardNo, String contact, String securityStationName, String companyName, Double latitude, Double longitude, DutySignInType dutyStatus, Boolean dispatchable, String tencentUserId, String tenantImUserId, String superviseDepartId, String securityStationId, boolean isDevice, String cid, Set<String> followedDeviceNos, boolean followed, String responsibleOfStationId, Set<String> resourceTypes, String proprietorCompanyId, String proprietorCompanyName, String projectId, String projectName, String stationType) {
        this.searchModel = searchMode;
        this.id = id;
        if (GeoLocationValueType.isValidLocation((Double)latitude, (Double)longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }
        this.dutyStatus = dutyStatus == DutySignInType.SignIn ? (dispatchable != null && !dispatchable.booleanValue() ? DutySignInType.SignOut : dutyStatus) : dutyStatus;
        this.rts = resourceTypes;
        if (searchMode != EmployeeSearchRequest.SearchModel.SecurityResource) {
            this.dutyStatusText = this.dutyStatus == DutySignInType.SignIn ? "\u5728\u5c97" : "\u79bb\u5c97";
            this.idCardNo = StringUtil.isEmpty((String)idCardNo) ? "" : idCardNo;
            this.contact = StringUtil.isEmpty((String)contact) ? "" : contact;
            this.projectName = projectName;
            this.stationType = stationType;
            this.name = name;
            this.organizationId = organizationId;
            this.companyName = companyName;
            this.cid = cid;
            this.tencentUserId = tencentUserId;
            this.tenantImUserId = tenantImUserId;
            this.securityStationId = securityStationId;
            this.securityStationName = StringUtil.isEmpty((String)securityStationName) ? "" : securityStationName;
            this.superviseDepartId = superviseDepartId;
            this.isDevice = isDevice;
            this.followedDeviceNos = followedDeviceNos;
            this.followed = followed;
            this.responsibleOfStationId = responsibleOfStationId;
            this.hasResource = this.getTencentUserId() != null && this.getTencentUserId().length() > 0;
            this.proprietorCompanyId = proprietorCompanyId;
            this.proprietorCompanyName = proprietorCompanyName;
        } else {
            this.projectName = null;
            this.stationType = stationType;
            this.dutyStatusText = null;
            this.idCardNo = null;
            this.contact = null;
            this.companyName = null;
            this.cid = null;
            this.name = null;
            this.organizationId = null;
            this.tencentUserId = null;
            this.tenantImUserId = null;
            this.securityStationId = null;
            this.securityStationName = null;
            this.superviseDepartId = null;
            this.isDevice = null;
            this.followedDeviceNos = null;
            this.followed = null;
            this.hasResource = null;
            this.responsibleOfStationId = null;
            this.proprietorCompanyId = null;
            this.proprietorCompanyName = null;
        }
        this.stationResponsible = !StringUtil.isEmpty((String)responsibleOfStationId) && !"#1".equalsIgnoreCase(responsibleOfStationId);
    }

    public static EmployeeOverviewResponse create(EmployeeSearchRequest.SearchModel searchMode, String id, String organizationId, String name, String idCardNo, String contact, String securityStationName, String companyName, Double latitude, Double longitude, DutySignInType dutyStatus, Boolean dispatchable, String tencentUserId, String tenantImUserId, String superviseDepartId, String securityStationId, boolean isDevice, String cid, Set<String> followedDeviceNos, boolean followed, String responsibleOfStationId, Set<String> resourceTypes, String proprietorCompanyId, String proprietorCompanyName, String projectId, String projectName, String stationType) {
        return new EmployeeOverviewResponse(searchMode, id, organizationId, name, idCardNo, contact, securityStationName, companyName, latitude, longitude, dutyStatus, dispatchable, tencentUserId, tenantImUserId, superviseDepartId, securityStationId, isDevice, cid, followedDeviceNos, followed, responsibleOfStationId, resourceTypes, proprietorCompanyId, proprietorCompanyName, projectId, projectName, stationType);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public String getContact() {
        return this.contact;
    }

    public DutySignInType getDutyStatus() {
        return this.dutyStatus;
    }

    public String getDutyStatusText() {
        return this.dutyStatusText;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getTencentUserId() {
        return this.tencentUserId;
    }

    public String getTenantImUserId() {
        return this.tenantImUserId;
    }

    public String getCid() {
        return this.cid;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public Boolean getFollowed() {
        return this.followed;
    }

    public Boolean getHasResource() {
        return this.hasResource;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public boolean isStationResponsible() {
        return this.stationResponsible;
    }

    public String getResponsibleOfStationId() {
        return this.responsibleOfStationId;
    }

    public Set<String> getRts() {
        return this.rts;
    }

    public String getProprietorCompanyId() {
        return this.proprietorCompanyId;
    }

    public String getProprietorCompanyName() {
        return this.proprietorCompanyName;
    }

    public EmployeeSearchRequest.SearchModel getSearchModel() {
        return this.searchModel;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStationType() {
        return this.stationType;
    }
}

