/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Arrays;
import java.util.Optional;

public class TRTCActionWriterRpcRequest
extends RequestAbstract {
    private TRTCActionType action;
    private String[] tencentUserIds;

    @JsonSetter(value="action")
    public void setActionType(String action) {
        Optional<TRTCActionType> actionOptional = Arrays.stream(TRTCActionType.values()).filter(ix -> ix.getName().equalsIgnoreCase(action)).findFirst();
        if (actionOptional.isPresent()) {
            this.action = actionOptional.get();
        }
    }

    public static TRTCActionWriterRpcRequest create(TRTCActionType action, String[] tencentUserIds) {
        TRTCActionWriterRpcRequest request = new TRTCActionWriterRpcRequest();
        request.setAction(action);
        request.setTencentUserIds(tencentUserIds);
        return request;
    }

    public TRTCActionType getAction() {
        return this.action;
    }

    public String[] getTencentUserIds() {
        return this.tencentUserIds;
    }

    public void setAction(TRTCActionType action) {
        this.action = action;
    }

    public void setTencentUserIds(String[] tencentUserIds) {
        this.tencentUserIds = tencentUserIds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TRTCActionWriterRpcRequest)) {
            return false;
        }
        TRTCActionWriterRpcRequest other = (TRTCActionWriterRpcRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TRTCActionType this$action = this.getAction();
        TRTCActionType other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getTencentUserIds(), other.getTencentUserIds());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TRTCActionWriterRpcRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TRTCActionType $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTencentUserIds());
        return result;
    }

    @Override
    public String toString() {
        return "TRTCActionWriterRpcRequest(action=" + this.getAction() + ", tencentUserIds=" + Arrays.deepToString(this.getTencentUserIds()) + ")";
    }
}

