package com.bcxin.tenant.open.dubbo.writer.providers.translates;

import com.bcxin.tenant.open.document.domains.documents.*;
import com.bcxin.tenant.open.document.domains.repositories.RdCompanyDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdProjectDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.domains.entities.*;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.repositories.AttendanceRepository;
import com.bcxin.tenant.open.domains.services.commands.CreateRoomCommandResponse;
import com.bcxin.tenant.open.domains.services.commands.InviteRoomUserCommandResponse;
import com.bcxin.tenant.open.jdks.requests.CreateRoomWriterRpcRequest;
import com.bcxin.tenant.open.jdks.requests.InviteRoomUsersWriterRpcRequest;
import com.bcxin.tenant.open.jdks.requests.OrgPursePointRequest;
import com.bcxin.tenant.open.jdks.responses.*;
import com.redis.om.spring.search.stream.EntityStream;

import java.util.Collection;

public interface DataTranslate {
    Collection<RdEmployeeDocument> translate(Collection<RdEmployeeEntity> employees,
                                             boolean isFlushStation,
                                             RdEmployeeDocumentRepository employeeDocumentRepository,
                                             AttendanceRepository attendanceRepository,
                                             RdCompositedReader compositedReader);

    Collection<RdCompanyDocument> translate2Company(Collection<RdCompanyEntity> companies,
                                                    RdCompanyDocumentRepository companyDocumentRepository,
                                                    RdCompositedReader compositedReade);

    Collection<RdSecurityStationDocument> translate2Stations(Collection<RdSecurityStationEntity> securityStations,
                                                             RdSecurityStationDocumentRepository securityStationDocumentRepository,
                                                             RdCompositedReader compositedReader,
                                                             Collection<StationDeviceEntity> stationDevices);

    RdDeviceDeskPermissionResponse translate(RdDeviceDeskPermissionDocument document);

    OrgPurseValidateResponse translate2OrgPurses(OrgPursePointRequest request, Collection<OrgPurseDocument> documents);

    PoliceIncidentOverviewResponse translate2PoliceIncidentsDetailReaderResponse(PoliceIncidentsEntity pie);

    CreateRoomWriterRpcResponse translate(CreateRoomCommandResponse commandResponse,
                                          CreateRoomWriterRpcRequest request,
                                          Collection<OrgPurseEntity> orgPurses
    );


    Collection<RdExamSiteDocument> translate2ExamSites(Collection<RdExamSiteEntity> examSites);

    Collection<RdExamSiteRoomDocument> translate2ExamSiteRooms(Collection<RdExamSiteRoomEntity> examSiteRooms);

    Collection<RdSystemExamInfoDocument> translate2SystemExamInfo(Collection<RdSystemExamInfoEntity> systemExamInfos);

    InviteRoomUsersWriterRpcResponse translate(InviteRoomUserCommandResponse commandResponse, InviteRoomUsersWriterRpcRequest request,
                                               Collection<OrgPurseEntity> orgPurses);

    Collection<RdCommunityUserDocument> translate(Collection<RdCommunityUserEntity> communityUsers);

    Collection<RdProjectDocument> translate(Collection<RdProjectEntity> projectEntities,
                                            RdProjectDocumentRepository projectDocumentRepository
    );

    ProjectResponse translate(RdProjectEntity project, EntityStream entityStream,boolean forDetail);

    Collection<ProjectTeamResponse> translateProjectTeams(Collection<RdProjectTeamGroupEntity> teamGroups);

    Collection<RdDeviceDocument> translate2DeviceDocuments(Collection<RdDeviceEntity> devices);
}
